package com.ai.osmos.ads.views.interfaces

import android.app.Activity
import android.content.Context
import android.view.View
import com.ai.osmos.utils.error.ErrorCallback

/**
 * Project Name: OSMOS-Android-SDK
 * File Name: NativeAdHorizontalViewInterface
 *
 * Interface for native ad horizontal view functionality in the OSMOS SDK.
 * Provides methods for loading and displaying native advertisements in horizontal layouts.
 */
public interface NativeAdHorizontalViewInterface {

    /**
     * Load ad data into the Native Ad Horizontal view
     */
    fun loadAd(adData: Map<String, Any>, context: Context)

    /**
     * Load ad data into the Native Ad Horizontal view with activity context
     */
    fun loadAd(adData: Map<String, Any>, activity: Activity?)

    /**
     * Set listener for ad click events
     */
    fun setAdClickListener(listener: (adMetadata: Map<String, Any>?) -> Unit)

    /**
     * Set listener for view load events
     */
    fun setViewLoadListener(listener: (adData: Map<String, Any>, String) -> Unit)

    /**
     * Set listener for ad item click events
     */
    fun setAdItemClickListener(listener: (adData: Map<String, Any>, clickedItem: Map<String, Any>, destinationUrl: String) -> Unit)

    /**
     * Set error callback for handling errors
     */
    fun setErrorCallback(callback: ErrorCallback?)

    /**
     * Clear error callback
     */
    fun clearErrorCallback()

    /**
     * Get the underlying View for adding to view hierarchy
     */
    fun getView(): View
}