package com.ai.osmos.ads.views.interfaces

import android.app.Activity
import android.content.Context
import android.view.View

/**
 * Interface for PDA ad horizontal view functionality.
 * Provides methods for loading ads, setting listeners, and managing the view lifecycle.
 */
interface PDAAdHorizontalViewInterface {
    /**
     * Load ad with context
     */
    fun loadAd(adData: Map<String, Any>, context: Context)

    /**
     * Load ad with activity
     */
    fun loadAd(adData: Map<String, Any>, activity: Activity?)

    /**
     * Set ad click listener
     */
    fun setAdClickListener(listener: (adMetadata: Map<String, Any>?) -> Unit)

    /**
     * Set view load listener
     */
    fun setViewLoadListener(listener: (adData: Map<String, Any>, String) -> Unit)

    /**
     * Set error callback
     */
    fun setErrorCallback(callback: com.ai.osmos.utils.error.ErrorCallback?)

    /**
     * Clear error callback
     */
    fun clearErrorCallback()

    /**
     * Get the underlying view
     */
    fun getView(): View
}