package com.ai.osmos.ads.views.managers

import androidx.media3.exoplayer.ExoPlayer

object AdVideoManager {
    private val playerMap: MutableMap<String, ExoPlayer> = mutableMapOf()

    fun registerPlayer(adId: String, player: ExoPlayer) {
        playerMap[adId] = player
    }

    fun pausePlayer(adId: String) {
        playerMap[adId]?.pause()
    }

    fun resumePlayer(adId: String) {
        playerMap[adId]?.play()
    }

    fun removePlayer(adId: String) {
        playerMap.remove(adId)
    }

    fun pauseAll() {
        playerMap.values.forEach { it.pause() }
    }

    fun resumeAll() {
        playerMap.values.forEach { it.play() }
    }
}