package com.ai.osmos.ads.views.style

import android.graphics.Typeface
import com.ai.osmos.models.enums.NativeAdLayoutType

/**
 * Project Name: OSMOS-Android-SDK
 * File Name: CustomStyle
 */

data class TextStyle(
    val font: Typeface? = null,
    val color: Int? = null,
    val backgroundColor: Int? = null,
    val textSizeSp: Float? = null
)

val DEFAULT_TEXT_STYLE = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFF000000.toInt(), // Default black color
    textSizeSp = 20f            // Default 14sp text
)

val defaultTitleStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFF000000.toInt(), // Black
    textSizeSp = 18f            // Default 14sp text
)

val defaultSkuDescriptionStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFFA9A9A9.toInt(), //Gray
    textSizeSp = 14f            // Default 14sp text
)

val defaultDeliveryDetailStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFFA9A9A9.toInt(), // Default Light Gray color 0xFFD3D3D3
    textSizeSp = 14f            // Default 14sp text
)
val defaultOriginalPriceStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFFA9A9A9.toInt(), // Gray color
    textSizeSp = 14f            // Default 14sp text
)
val defaultDiscountedPriceStyle = TextStyle(
    font = Typeface.DEFAULT_BOLD,
    color = 0xFF000000.toInt(), // Black
    textSizeSp = 18f            // Default 14sp text
)
val defaultOfferStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFF006400.toInt(), // Green
    textSizeSp = 14f            // Default 14sp text
)

val defaultMembershipStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFF000000.toInt(), //  Blue
    textSizeSp = 14f            // Default 14sp text
)
val defaultRatingStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFFFFFFFF.toInt(), // White
    backgroundColor = 0xFF006400.toInt(), //Green
    textSizeSp = 14f            // Default 14sp text
)

val defaultRatingCountStyle = TextStyle(
    font = Typeface.DEFAULT,
    color = 0xFFA9A9A9.toInt(), // Gray
    textSizeSp = 14f            // Default 14sp text
)

data class NativeAdCustomStyle(
    val titleTextStyle: TextStyle? = defaultTitleStyle,
    val skuDescriptionTextStyle: TextStyle? = defaultSkuDescriptionStyle,
    val deliveryDetailTextStyle: TextStyle? = defaultDeliveryDetailStyle,
    val originalPriceTextStyle: TextStyle? = defaultOriginalPriceStyle,
    val discountedPriceTextStyle: TextStyle? = defaultDiscountedPriceStyle,
    val offerTextStyle: TextStyle? = defaultOfferStyle,
    val membershipPriceTextStyle: TextStyle? = defaultMembershipStyle,
    val ratingTextStyle: TextStyle? = defaultRatingStyle,
    val ratingCountTextStyle: TextStyle? = defaultRatingCountStyle,

    val mediaHeight: Int? = null,
    val mediaWidth: Int? = null,

    val ctaTitle: String? = null,
    val ctaAction: (() -> Unit)? = null,

    val adType: NativeAdLayoutType = NativeAdLayoutType.Small,
)