package com.ai.osmos.ads.views.style

import android.annotation.SuppressLint
import android.view.View
import androidx.recyclerview.widget.RecyclerView
import com.ai.osmos.ads.views.PDAProductStyle
import com.ai.osmos.models.ads.NativeAd
import com.ai.osmos.models.enums.NativeAdLayoutType

@SuppressLint("StaticFieldLeak")
val defaultPDAAdCustomStyle = PDAAdCustomStyle(
    bannerWidth = 250,
    bannerHeight = 250,

    productScrollDirection = RecyclerView.HORIZONTAL, // or VERTICAL depending on default behavior
    pdaProductStyle = PDAProductStyle.Horizontal, // or NATIVE_VERTICAL as default

    nativeAdWidth = 150,
    nativeAdHeight = 150,
    nativeAdLayoutType = NativeAdLayoutType.Medium, // Default size

    nativeStyle = NativeAdCustomStyle(), // Uses all default TextStyle values

    ctaButton = null,

    nativeAdViewLoad = null,
    nativeAdClicked = null
)

data class PDAAdCustomStyle(
    val bannerWidth: Int? = null,
    val bannerHeight: Int? = null,

    val productScrollDirection: Int,
    val pdaProductStyle: PDAProductStyle, //Native Horizontal, Native Vertical

    val nativeAdWidth: Int? = null,
    val nativeAdHeight: Int? = null,
    val nativeAdLayoutType: NativeAdLayoutType, // Small,Medium and Large
    val nativeStyle: NativeAdCustomStyle,
    val ctaButton: View?,

    val nativeAdViewLoad: ((NativeAd) -> Void)?,

    val nativeAdClicked: ((NativeAd) -> Void)?
)