package com.ai.osmos.models.ads

/**
 * Base class for all ad types in the OSMOS SDK.
 * Contains common properties shared across all ad formats.
 */
abstract class BaseAd {
    abstract val elementsType: AdType // Type of ad (banner, video, carousel, etc.)
    abstract val crt: String // Creative template identifier
    abstract val cliUbid: String? // Client unique browser ID for tracking
    abstract val adMetadata: Map<String, Any>? // Additional ad data and targeting info
}