package com.ai.osmos.tracking.tracker

import com.ai.osmos.models.events.VideoActionType
import com.ai.osmos.utils.error.ErrorCallback

/**
 * Project Name: OSMOS-Android-SDK
 * File Name: AdTrackerInterface
 *
 * Common interface for all ad tracking implementations.
 * This eliminates code duplication and provides a consistent API.
 */
interface AdTrackerInterface {

    /**
     * Tracks when an ad impression occurs (i.e., when an ad becomes visible).
     */
    fun trackImpression(uclid: String, cliUbid: String, position: Int = 1)

    /**
     * Tracks when the user clicks on an ad.
     */
    fun trackAdClick(uclid: String, cliUbid: String)

    /**
     * Tracks a specific video action (e.g., "mute", "unmute").
     */
    fun videoActionClick(
        uclid: String,
        cliUbid: String,
        actionType: VideoActionType,
        videoViewSec: Float
    )

    /**
     * Tracks periodic progress updates during video playback.
     */
    fun videoProgressEvent(
        uclid: String,
        cliUbid: String,
        videoViewSec: Float,
        videoDurationSec: Float
    )

    /**
     * Set an error callback to handle errors that occur during tracking.
     */
    fun setErrorCallback(callback: ErrorCallback?)

}
