package com.ai.osmos.utils.common

/**
 * HTTP methods supported by the SDK
 */
enum class HttpMethod(val method: String) {
    GET("GET"),
    POST("POST")
}

/**
 * API endpoint paths for different ad and tracking services
 */
enum class ApiEndpoint(val endpoint: String) {
    DISPLAY_ADS("/v2/bsda"), // Display ads with ad units
    DISPLAY_ADS_PT("/v2/bsda/pt"), // Display ads with page type
    PLA_ADS("/sda"), // Product listing ads
    TPA_ADS("/sda/v1"), // Tagged product ads
    AD_CLICK("/aclick"), // Ad click tracking
    AD_TRACKING("/events") // General event tracking
}

object Constants {
    const val CONNECT_TIMEOUT = 10000         // 10 seconds
    const val READ_TIMEOUT = 30000           // 30 seconds
    const val CLOSE_BUTTON_SEC_DEFAULT = 3      // 3 Sec
    const val VIDEO_PROGRESS_SEC_DEFAULT = 3    //3 sec
    const val PIP_AD_WIDTH = 180
    const val PIP_AD_HEIGHT = 320
    const val SLIDER_AD_HEIGHT = 320
    const val SLIDER_AD_WIDTH = 180
    const val CAROUSEL_AD_WIDTH = 320
    const val CAROUSEL_AD_HEIGHT = 120
    const val CRT_BANNER_VIDEO = "osmos_sdk/video/v1/"
    const val CRT_BANNER_IMAGE = "osmos_sdk/image/v1/"
    const val CRT_CAROUSEL = "osmos_sdk/carousel/v1/"

    // OS Information
    const val OS_NAME = "ANDROID"
    const val SDK_VERSION = "2.2.0"

    // Log Tags
    const val LOG_TAG = "OSMOS"

    // JSON Response Keys
    const val JSON_KEY_STATUS = "status"
    const val JSON_KEY_RESPONSE = "response"
    const val JSON_KEY_ERROR = "error"
    const val JSON_KEY_CODE = "code"
    const val JSON_KEY_DATA = "data"

    const val CURRENCY_SYMBOL = "₹"
    const val BG_COLOR = "#66808080"
    const val PADDING_5 = 5
}