package com.ai.osmos.utils.common

import android.content.Context
import androidx.annotation.DrawableRes

/**
 * Project Name: OSMOS-Android-SDK
 * File Name: ResourceManager
 */
object DrawableResourceManager {
    var provider: ResourceProvider? = null

    @DrawableRes
    fun getMuteIcon(context: Context): Int {
        return provider?.getMuteIconRes() ?: getResourceIdByName(context, "mute")
    }

    @DrawableRes
    fun getUnMuteIcon(context: Context): Int {
        return provider?.getUnMuteIconRes() ?: getResourceIdByName(context, "unmute")
    }

    @DrawableRes
    fun getFullScreenIcon(context: Context): Int {
        return provider?.getFullScreenIconRes() ?: getResourceIdByName(context, "fullscreen")
    }


    @DrawableRes
    fun getExitFullScreenIcon(context: Context): Int {
        return provider?.getExitFullScreenIconRes() ?: getResourceIdByName(
            context,
            "exit_fullscreen"
        )
    }

    @DrawableRes
    fun getDotActiveIcon(context: Context): Int {
        return provider?.getDotActiveIconRes() ?: getResourceIdByName(context, "dot_active")
    }

    @DrawableRes
    fun getDotInActiveIcon(context: Context): Int {
        return provider?.getDotInActiveIconRes() ?: getResourceIdByName(context, "dot_inactive")
    }

}

fun getResourceIdByName(context: Context, name: String): Int {
    val resId = context.resources.getIdentifier(name, "drawable", context.packageName)
    return resId;
}