package com.ai.osmos.utils.error

/**
 * Project Name: OSMOS-Android-SDK
 * File Name: ExceptionHandler
 *
 * Custom exception class for WebService errors.
 * Contains structured error information that can be passed to ErrorCallback.
 */
class ExceptionHandler(
    val errorCode: String,
    val errorMessage: String,
    cause: Throwable? = null
) : Exception("$errorCode: $errorMessage", cause) {

    /**
     * Constructor using Error enum with default message
     */
    constructor(error: OsmosError, cause: Throwable? = null) : this(
        errorCode = error.code,
        errorMessage = error.message,
        cause = cause
    )

    /**
     * Constructor using Error enum with custom message
     */
    constructor(error: OsmosError, customMessage: String, cause: Throwable? = null) : this(
        errorCode = error.code,
        errorMessage = customMessage,
        cause = cause
    )

}