package com.ai.osmos.utils.logging

import android.util.Log

/**
 * Simple debug logging utility with global debug flag
 * Made public to allow client applications to access logging functionality
 */
object DebugLogger {

    @Volatile
    private var isDebugEnabled = false

    fun setDebugEnabled(enabled: Boolean) {
        isDebugEnabled = enabled
    }

    fun log(message: String) {
        if (isDebugEnabled) {
            Log.d("OSMOS_SDK", message)
        }
    }

    fun log(tag: String, message: String) {
        if (isDebugEnabled) {
            Log.d(tag, message)
        }
    }
}
