package com.ai.osmos.utils.ui

import android.view.View

fun View.isVisibleInScreen(): Boolean {
    if (!isShown) return false

    val location = IntArray(2)
    getLocationOnScreen(location)

    val screenWidth = resources.displayMetrics.widthPixels
    val screenHeight = resources.displayMetrics.heightPixels

    val visibleWidth = maxOf(0, minOf(location[0] + width, screenWidth) - maxOf(location[0], 0))
    val visibleHeight = maxOf(0, minOf(location[1] + height, screenHeight) - maxOf(location[1], 0))

    val visibleArea = visibleWidth * visibleHeight
    val totalArea = width * height

    return if (totalArea > 0) visibleArea.toFloat() / totalArea >= 0.5f else false
}

