/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package ai.oursky.astro.api.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import ai.oursky.astro.api.models.EmptySuccess
import ai.oursky.astro.api.models.SuccessfulCreate
import ai.oursky.astro.api.models.V1AstroProject
import ai.oursky.astro.api.models.V1AstroProjectAsset
import ai.oursky.astro.api.models.V1AstroTarget
import ai.oursky.astro.api.models.V1CalibrationMaster
import ai.oursky.astro.api.models.V1Camera
import ai.oursky.astro.api.models.V1CreateAstroProjectImageSetRequest
import ai.oursky.astro.api.models.V1CreateAstroProjectRequest
import ai.oursky.astro.api.models.V1CreateAstroProjectResponse
import ai.oursky.astro.api.models.V1CreateCalibrationMasterRequest
import ai.oursky.astro.api.models.V1CreateCalibrationMasterResponse
import ai.oursky.astro.api.models.V1CreateCameraRequest
import ai.oursky.astro.api.models.V1CreateImageSetImageRequest
import ai.oursky.astro.api.models.V1CreateImageSetImageResponse
import ai.oursky.astro.api.models.V1CreateImageSetRequest
import ai.oursky.astro.api.models.V1CreateMountRequest
import ai.oursky.astro.api.models.V1CreateNodeRequest
import ai.oursky.astro.api.models.V1CreateOpticalTubeRequest
import ai.oursky.astro.api.models.V1GetAstroPlatformCreditBalanceResponse
import ai.oursky.astro.api.models.V1GetNodes
import ai.oursky.astro.api.models.V1GetOrCreateCameraRequest
import ai.oursky.astro.api.models.V1GetOrCreateMountRequest
import ai.oursky.astro.api.models.V1GetOrCreateOpticalTubeRequest
import ai.oursky.astro.api.models.V1ImageSet
import ai.oursky.astro.api.models.V1ImageSetImage
import ai.oursky.astro.api.models.V1JobLog
import ai.oursky.astro.api.models.V1Mount
import ai.oursky.astro.api.models.V1OpticalTube
import ai.oursky.astro.api.models.V1PlatformCredit
import ai.oursky.astro.api.models.V1PutStackAstroProjectRequest
import ai.oursky.astro.api.models.V1UpdateNodeRequest

import com.fasterxml.jackson.annotation.JsonProperty

import ai.oursky.astro.api.infrastructure.ApiClient
import ai.oursky.astro.api.infrastructure.ApiResponse
import ai.oursky.astro.api.infrastructure.ClientException
import ai.oursky.astro.api.infrastructure.ClientError
import ai.oursky.astro.api.infrastructure.ServerException
import ai.oursky.astro.api.infrastructure.ServerError
import ai.oursky.astro.api.infrastructure.MultiValueMap
import ai.oursky.astro.api.infrastructure.PartConfig
import ai.oursky.astro.api.infrastructure.RequestConfig
import ai.oursky.astro.api.infrastructure.RequestMethod
import ai.oursky.astro.api.infrastructure.ResponseType
import ai.oursky.astro.api.infrastructure.Success
import ai.oursky.astro.api.infrastructure.toMultiValue

class DefaultApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://api.prod.oursky.ai")
        }
    }

    /**
     * 
     * Match camera.
     * @param model  (optional)
     * @param pixelSizeMicrons  (optional)
     * @param pixelsX  (optional)
     * @param pixelsY  (optional)
     * @param megapixels  (optional)
     * @param chilled  (optional)
     * @param adcBitDepth  (optional)
     * @param isColor  (optional)
     * @return kotlin.collections.List<V1Camera>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CameraMatch(model: kotlin.String? = null, pixelSizeMicrons: kotlin.Double? = null, pixelsX: kotlin.Int? = null, pixelsY: kotlin.Int? = null, megapixels: kotlin.Double? = null, chilled: kotlin.Boolean? = null, adcBitDepth: kotlin.Int? = null, isColor: kotlin.Boolean? = null) : kotlin.collections.List<V1Camera> {
        val localVarResponse = v1CameraMatchWithHttpInfo(model = model, pixelSizeMicrons = pixelSizeMicrons, pixelsX = pixelsX, pixelsY = pixelsY, megapixels = megapixels, chilled = chilled, adcBitDepth = adcBitDepth, isColor = isColor)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1Camera>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Match camera.
     * @param model  (optional)
     * @param pixelSizeMicrons  (optional)
     * @param pixelsX  (optional)
     * @param pixelsY  (optional)
     * @param megapixels  (optional)
     * @param chilled  (optional)
     * @param adcBitDepth  (optional)
     * @param isColor  (optional)
     * @return ApiResponse<kotlin.collections.List<V1Camera>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CameraMatchWithHttpInfo(model: kotlin.String?, pixelSizeMicrons: kotlin.Double?, pixelsX: kotlin.Int?, pixelsY: kotlin.Int?, megapixels: kotlin.Double?, chilled: kotlin.Boolean?, adcBitDepth: kotlin.Int?, isColor: kotlin.Boolean?) : ApiResponse<kotlin.collections.List<V1Camera>?> {
        val localVariableConfig = v1CameraMatchRequestConfig(model = model, pixelSizeMicrons = pixelSizeMicrons, pixelsX = pixelsX, pixelsY = pixelsY, megapixels = megapixels, chilled = chilled, adcBitDepth = adcBitDepth, isColor = isColor)

        return request<Unit, kotlin.collections.List<V1Camera>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CameraMatch
     *
     * @param model  (optional)
     * @param pixelSizeMicrons  (optional)
     * @param pixelsX  (optional)
     * @param pixelsY  (optional)
     * @param megapixels  (optional)
     * @param chilled  (optional)
     * @param adcBitDepth  (optional)
     * @param isColor  (optional)
     * @return RequestConfig
     */
    fun v1CameraMatchRequestConfig(model: kotlin.String?, pixelSizeMicrons: kotlin.Double?, pixelsX: kotlin.Int?, pixelsY: kotlin.Int?, megapixels: kotlin.Double?, chilled: kotlin.Boolean?, adcBitDepth: kotlin.Int?, isColor: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (model != null) {
                    put("model", listOf(model.toString()))
                }
                if (pixelSizeMicrons != null) {
                    put("pixelSizeMicrons", listOf(pixelSizeMicrons.toString()))
                }
                if (pixelsX != null) {
                    put("pixelsX", listOf(pixelsX.toString()))
                }
                if (pixelsY != null) {
                    put("pixelsY", listOf(pixelsY.toString()))
                }
                if (megapixels != null) {
                    put("megapixels", listOf(megapixels.toString()))
                }
                if (chilled != null) {
                    put("chilled", listOf(chilled.toString()))
                }
                if (adcBitDepth != null) {
                    put("adcBitDepth", listOf(adcBitDepth.toString()))
                }
                if (isColor != null) {
                    put("isColor", listOf(isColor.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/camera-match",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create an astro camera.
     * @param v1CreateCameraRequest 
     * @return SuccessfulCreate
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateAstroCamera(v1CreateCameraRequest: V1CreateCameraRequest) : SuccessfulCreate {
        val localVarResponse = v1CreateAstroCameraWithHttpInfo(v1CreateCameraRequest = v1CreateCameraRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SuccessfulCreate
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create an astro camera.
     * @param v1CreateCameraRequest 
     * @return ApiResponse<SuccessfulCreate?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateAstroCameraWithHttpInfo(v1CreateCameraRequest: V1CreateCameraRequest) : ApiResponse<SuccessfulCreate?> {
        val localVariableConfig = v1CreateAstroCameraRequestConfig(v1CreateCameraRequest = v1CreateCameraRequest)

        return request<V1CreateCameraRequest, SuccessfulCreate>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateAstroCamera
     *
     * @param v1CreateCameraRequest 
     * @return RequestConfig
     */
    fun v1CreateAstroCameraRequestConfig(v1CreateCameraRequest: V1CreateCameraRequest) : RequestConfig<V1CreateCameraRequest> {
        val localVariableBody = v1CreateCameraRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/astro-camera",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create an astro mount.
     * @param v1CreateMountRequest 
     * @return SuccessfulCreate
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateAstroMount(v1CreateMountRequest: V1CreateMountRequest) : SuccessfulCreate {
        val localVarResponse = v1CreateAstroMountWithHttpInfo(v1CreateMountRequest = v1CreateMountRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SuccessfulCreate
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create an astro mount.
     * @param v1CreateMountRequest 
     * @return ApiResponse<SuccessfulCreate?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateAstroMountWithHttpInfo(v1CreateMountRequest: V1CreateMountRequest) : ApiResponse<SuccessfulCreate?> {
        val localVariableConfig = v1CreateAstroMountRequestConfig(v1CreateMountRequest = v1CreateMountRequest)

        return request<V1CreateMountRequest, SuccessfulCreate>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateAstroMount
     *
     * @param v1CreateMountRequest 
     * @return RequestConfig
     */
    fun v1CreateAstroMountRequestConfig(v1CreateMountRequest: V1CreateMountRequest) : RequestConfig<V1CreateMountRequest> {
        val localVariableBody = v1CreateMountRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/astro-mount",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create an astro optical tube.
     * @param v1CreateOpticalTubeRequest 
     * @return SuccessfulCreate
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateAstroOpticalTube(v1CreateOpticalTubeRequest: V1CreateOpticalTubeRequest) : SuccessfulCreate {
        val localVarResponse = v1CreateAstroOpticalTubeWithHttpInfo(v1CreateOpticalTubeRequest = v1CreateOpticalTubeRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SuccessfulCreate
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create an astro optical tube.
     * @param v1CreateOpticalTubeRequest 
     * @return ApiResponse<SuccessfulCreate?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateAstroOpticalTubeWithHttpInfo(v1CreateOpticalTubeRequest: V1CreateOpticalTubeRequest) : ApiResponse<SuccessfulCreate?> {
        val localVariableConfig = v1CreateAstroOpticalTubeRequestConfig(v1CreateOpticalTubeRequest = v1CreateOpticalTubeRequest)

        return request<V1CreateOpticalTubeRequest, SuccessfulCreate>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateAstroOpticalTube
     *
     * @param v1CreateOpticalTubeRequest 
     * @return RequestConfig
     */
    fun v1CreateAstroOpticalTubeRequestConfig(v1CreateOpticalTubeRequest: V1CreateOpticalTubeRequest) : RequestConfig<V1CreateOpticalTubeRequest> {
        val localVariableBody = v1CreateOpticalTubeRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/astro-optical-tube",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create an astro project.
     * @param v1CreateAstroProjectRequest 
     * @return V1CreateAstroProjectResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateAstroProject(v1CreateAstroProjectRequest: V1CreateAstroProjectRequest) : V1CreateAstroProjectResponse {
        val localVarResponse = v1CreateAstroProjectWithHttpInfo(v1CreateAstroProjectRequest = v1CreateAstroProjectRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1CreateAstroProjectResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create an astro project.
     * @param v1CreateAstroProjectRequest 
     * @return ApiResponse<V1CreateAstroProjectResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateAstroProjectWithHttpInfo(v1CreateAstroProjectRequest: V1CreateAstroProjectRequest) : ApiResponse<V1CreateAstroProjectResponse?> {
        val localVariableConfig = v1CreateAstroProjectRequestConfig(v1CreateAstroProjectRequest = v1CreateAstroProjectRequest)

        return request<V1CreateAstroProjectRequest, V1CreateAstroProjectResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateAstroProject
     *
     * @param v1CreateAstroProjectRequest 
     * @return RequestConfig
     */
    fun v1CreateAstroProjectRequestConfig(v1CreateAstroProjectRequest: V1CreateAstroProjectRequest) : RequestConfig<V1CreateAstroProjectRequest> {
        val localVariableBody = v1CreateAstroProjectRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/astro-project",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create an astro project image set.
     * @param v1CreateAstroProjectImageSetRequest 
     * @return SuccessfulCreate
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateAstroProjectImageSet(v1CreateAstroProjectImageSetRequest: V1CreateAstroProjectImageSetRequest) : SuccessfulCreate {
        val localVarResponse = v1CreateAstroProjectImageSetWithHttpInfo(v1CreateAstroProjectImageSetRequest = v1CreateAstroProjectImageSetRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SuccessfulCreate
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create an astro project image set.
     * @param v1CreateAstroProjectImageSetRequest 
     * @return ApiResponse<SuccessfulCreate?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateAstroProjectImageSetWithHttpInfo(v1CreateAstroProjectImageSetRequest: V1CreateAstroProjectImageSetRequest) : ApiResponse<SuccessfulCreate?> {
        val localVariableConfig = v1CreateAstroProjectImageSetRequestConfig(v1CreateAstroProjectImageSetRequest = v1CreateAstroProjectImageSetRequest)

        return request<V1CreateAstroProjectImageSetRequest, SuccessfulCreate>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateAstroProjectImageSet
     *
     * @param v1CreateAstroProjectImageSetRequest 
     * @return RequestConfig
     */
    fun v1CreateAstroProjectImageSetRequestConfig(v1CreateAstroProjectImageSetRequest: V1CreateAstroProjectImageSetRequest) : RequestConfig<V1CreateAstroProjectImageSetRequest> {
        val localVariableBody = v1CreateAstroProjectImageSetRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/astro-project-image-set",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create a calibration master.
     * @param v1CreateCalibrationMasterRequest 
     * @return V1CreateCalibrationMasterResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateCalibrationMaster(v1CreateCalibrationMasterRequest: V1CreateCalibrationMasterRequest) : V1CreateCalibrationMasterResponse {
        val localVarResponse = v1CreateCalibrationMasterWithHttpInfo(v1CreateCalibrationMasterRequest = v1CreateCalibrationMasterRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1CreateCalibrationMasterResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create a calibration master.
     * @param v1CreateCalibrationMasterRequest 
     * @return ApiResponse<V1CreateCalibrationMasterResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateCalibrationMasterWithHttpInfo(v1CreateCalibrationMasterRequest: V1CreateCalibrationMasterRequest) : ApiResponse<V1CreateCalibrationMasterResponse?> {
        val localVariableConfig = v1CreateCalibrationMasterRequestConfig(v1CreateCalibrationMasterRequest = v1CreateCalibrationMasterRequest)

        return request<V1CreateCalibrationMasterRequest, V1CreateCalibrationMasterResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateCalibrationMaster
     *
     * @param v1CreateCalibrationMasterRequest 
     * @return RequestConfig
     */
    fun v1CreateCalibrationMasterRequestConfig(v1CreateCalibrationMasterRequest: V1CreateCalibrationMasterRequest) : RequestConfig<V1CreateCalibrationMasterRequest> {
        val localVariableBody = v1CreateCalibrationMasterRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/calibration-master",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create an image set.
     * @param v1CreateImageSetRequest 
     * @return SuccessfulCreate
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateImageSet(v1CreateImageSetRequest: V1CreateImageSetRequest) : SuccessfulCreate {
        val localVarResponse = v1CreateImageSetWithHttpInfo(v1CreateImageSetRequest = v1CreateImageSetRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SuccessfulCreate
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create an image set.
     * @param v1CreateImageSetRequest 
     * @return ApiResponse<SuccessfulCreate?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateImageSetWithHttpInfo(v1CreateImageSetRequest: V1CreateImageSetRequest) : ApiResponse<SuccessfulCreate?> {
        val localVariableConfig = v1CreateImageSetRequestConfig(v1CreateImageSetRequest = v1CreateImageSetRequest)

        return request<V1CreateImageSetRequest, SuccessfulCreate>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateImageSet
     *
     * @param v1CreateImageSetRequest 
     * @return RequestConfig
     */
    fun v1CreateImageSetRequestConfig(v1CreateImageSetRequest: V1CreateImageSetRequest) : RequestConfig<V1CreateImageSetRequest> {
        val localVariableBody = v1CreateImageSetRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/image-set",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create an image set image.
     * @param v1CreateImageSetImageRequest 
     * @return V1CreateImageSetImageResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateImageSetImage(v1CreateImageSetImageRequest: V1CreateImageSetImageRequest) : V1CreateImageSetImageResponse {
        val localVarResponse = v1CreateImageSetImageWithHttpInfo(v1CreateImageSetImageRequest = v1CreateImageSetImageRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1CreateImageSetImageResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create an image set image.
     * @param v1CreateImageSetImageRequest 
     * @return ApiResponse<V1CreateImageSetImageResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateImageSetImageWithHttpInfo(v1CreateImageSetImageRequest: V1CreateImageSetImageRequest) : ApiResponse<V1CreateImageSetImageResponse?> {
        val localVariableConfig = v1CreateImageSetImageRequestConfig(v1CreateImageSetImageRequest = v1CreateImageSetImageRequest)

        return request<V1CreateImageSetImageRequest, V1CreateImageSetImageResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateImageSetImage
     *
     * @param v1CreateImageSetImageRequest 
     * @return RequestConfig
     */
    fun v1CreateImageSetImageRequestConfig(v1CreateImageSetImageRequest: V1CreateImageSetImageRequest) : RequestConfig<V1CreateImageSetImageRequest> {
        val localVariableBody = v1CreateImageSetImageRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/image-set-image",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Create a node.
     * @param v1CreateNodeRequest 
     * @return SuccessfulCreate
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1CreateNode(v1CreateNodeRequest: V1CreateNodeRequest) : SuccessfulCreate {
        val localVarResponse = v1CreateNodeWithHttpInfo(v1CreateNodeRequest = v1CreateNodeRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SuccessfulCreate
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Create a node.
     * @param v1CreateNodeRequest 
     * @return ApiResponse<SuccessfulCreate?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1CreateNodeWithHttpInfo(v1CreateNodeRequest: V1CreateNodeRequest) : ApiResponse<SuccessfulCreate?> {
        val localVariableConfig = v1CreateNodeRequestConfig(v1CreateNodeRequest = v1CreateNodeRequest)

        return request<V1CreateNodeRequest, SuccessfulCreate>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1CreateNode
     *
     * @param v1CreateNodeRequest 
     * @return RequestConfig
     */
    fun v1CreateNodeRequestConfig(v1CreateNodeRequest: V1CreateNodeRequest) : RequestConfig<V1CreateNodeRequest> {
        val localVariableBody = v1CreateNodeRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/node",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Delete an image set.
     * @param id 
     * @return EmptySuccess
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1DeleteImageSet(id: java.util.UUID) : EmptySuccess {
        val localVarResponse = v1DeleteImageSetWithHttpInfo(id = id)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptySuccess
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Delete an image set.
     * @param id 
     * @return ApiResponse<EmptySuccess?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1DeleteImageSetWithHttpInfo(id: java.util.UUID) : ApiResponse<EmptySuccess?> {
        val localVariableConfig = v1DeleteImageSetRequestConfig(id = id)

        return request<Unit, EmptySuccess>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1DeleteImageSet
     *
     * @param id 
     * @return RequestConfig
     */
    fun v1DeleteImageSetRequestConfig(id: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("id", listOf(id.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/v1/image-set",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Delete an image.
     * @param imageId 
     * @return EmptySuccess
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1DeleteImageSetImage(imageId: java.util.UUID) : EmptySuccess {
        val localVarResponse = v1DeleteImageSetImageWithHttpInfo(imageId = imageId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptySuccess
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Delete an image.
     * @param imageId 
     * @return ApiResponse<EmptySuccess?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1DeleteImageSetImageWithHttpInfo(imageId: java.util.UUID) : ApiResponse<EmptySuccess?> {
        val localVariableConfig = v1DeleteImageSetImageRequestConfig(imageId = imageId)

        return request<Unit, EmptySuccess>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1DeleteImageSetImage
     *
     * @param imageId 
     * @return RequestConfig
     */
    fun v1DeleteImageSetImageRequestConfig(imageId: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("imageId", listOf(imageId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/v1/image-set-image",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get an astro camera.
     * @param id 
     * @return V1Camera
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroCamera(id: java.util.UUID) : V1Camera {
        val localVarResponse = v1GetAstroCameraWithHttpInfo(id = id)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1Camera
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get an astro camera.
     * @param id 
     * @return ApiResponse<V1Camera?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroCameraWithHttpInfo(id: java.util.UUID) : ApiResponse<V1Camera?> {
        val localVariableConfig = v1GetAstroCameraRequestConfig(id = id)

        return request<Unit, V1Camera>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroCamera
     *
     * @param id 
     * @return RequestConfig
     */
    fun v1GetAstroCameraRequestConfig(id: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("id", listOf(id.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-camera",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get an astro mount.
     * @param id 
     * @return V1Mount
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroMount(id: java.util.UUID) : V1Mount {
        val localVarResponse = v1GetAstroMountWithHttpInfo(id = id)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1Mount
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get an astro mount.
     * @param id 
     * @return ApiResponse<V1Mount?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroMountWithHttpInfo(id: java.util.UUID) : ApiResponse<V1Mount?> {
        val localVariableConfig = v1GetAstroMountRequestConfig(id = id)

        return request<Unit, V1Mount>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroMount
     *
     * @param id 
     * @return RequestConfig
     */
    fun v1GetAstroMountRequestConfig(id: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("id", listOf(id.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-mount",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get an astro optical tube.
     * @param id 
     * @return V1OpticalTube
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroOpticalTube(id: java.util.UUID) : V1OpticalTube {
        val localVarResponse = v1GetAstroOpticalTubeWithHttpInfo(id = id)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1OpticalTube
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get an astro optical tube.
     * @param id 
     * @return ApiResponse<V1OpticalTube?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroOpticalTubeWithHttpInfo(id: java.util.UUID) : ApiResponse<V1OpticalTube?> {
        val localVariableConfig = v1GetAstroOpticalTubeRequestConfig(id = id)

        return request<Unit, V1OpticalTube>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroOpticalTube
     *
     * @param id 
     * @return RequestConfig
     */
    fun v1GetAstroOpticalTubeRequestConfig(id: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("id", listOf(id.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-optical-tube",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get astro platform credit balance.
     * @return V1GetAstroPlatformCreditBalanceResponse
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroPlatformCreditBalance() : V1GetAstroPlatformCreditBalanceResponse {
        val localVarResponse = v1GetAstroPlatformCreditBalanceWithHttpInfo()

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1GetAstroPlatformCreditBalanceResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get astro platform credit balance.
     * @return ApiResponse<V1GetAstroPlatformCreditBalanceResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroPlatformCreditBalanceWithHttpInfo() : ApiResponse<V1GetAstroPlatformCreditBalanceResponse?> {
        val localVariableConfig = v1GetAstroPlatformCreditBalanceRequestConfig()

        return request<Unit, V1GetAstroPlatformCreditBalanceResponse>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroPlatformCreditBalance
     *
     * @return RequestConfig
     */
    fun v1GetAstroPlatformCreditBalanceRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-platform-credit-balance",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get an astro project.
     * @param astroProjectId 
     * @return V1AstroProject
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroProject(astroProjectId: java.util.UUID) : V1AstroProject {
        val localVarResponse = v1GetAstroProjectWithHttpInfo(astroProjectId = astroProjectId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1AstroProject
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get an astro project.
     * @param astroProjectId 
     * @return ApiResponse<V1AstroProject?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroProjectWithHttpInfo(astroProjectId: java.util.UUID) : ApiResponse<V1AstroProject?> {
        val localVariableConfig = v1GetAstroProjectRequestConfig(astroProjectId = astroProjectId)

        return request<Unit, V1AstroProject>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroProject
     *
     * @param astroProjectId 
     * @return RequestConfig
     */
    fun v1GetAstroProjectRequestConfig(astroProjectId: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("astroProjectId", listOf(astroProjectId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-project",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get astro project assets.
     * @param astroProjectId 
     * @return kotlin.collections.List<V1AstroProjectAsset>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroProjectAssets(astroProjectId: java.util.UUID) : kotlin.collections.List<V1AstroProjectAsset> {
        val localVarResponse = v1GetAstroProjectAssetsWithHttpInfo(astroProjectId = astroProjectId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1AstroProjectAsset>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get astro project assets.
     * @param astroProjectId 
     * @return ApiResponse<kotlin.collections.List<V1AstroProjectAsset>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroProjectAssetsWithHttpInfo(astroProjectId: java.util.UUID) : ApiResponse<kotlin.collections.List<V1AstroProjectAsset>?> {
        val localVariableConfig = v1GetAstroProjectAssetsRequestConfig(astroProjectId = astroProjectId)

        return request<Unit, kotlin.collections.List<V1AstroProjectAsset>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroProjectAssets
     *
     * @param astroProjectId 
     * @return RequestConfig
     */
    fun v1GetAstroProjectAssetsRequestConfig(astroProjectId: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("astroProjectId", listOf(astroProjectId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-project-assets",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get astro projects.
     * @return kotlin.collections.List<V1AstroProject>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroProjects() : kotlin.collections.List<V1AstroProject> {
        val localVarResponse = v1GetAstroProjectsWithHttpInfo()

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1AstroProject>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get astro projects.
     * @return ApiResponse<kotlin.collections.List<V1AstroProject>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroProjectsWithHttpInfo() : ApiResponse<kotlin.collections.List<V1AstroProject>?> {
        val localVariableConfig = v1GetAstroProjectsRequestConfig()

        return request<Unit, kotlin.collections.List<V1AstroProject>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroProjects
     *
     * @return RequestConfig
     */
    fun v1GetAstroProjectsRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-projects",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get an astro target. Pass in an ID, an NGC ID or an IC ID.
     * @param id  (optional)
     * @param ngcId  (optional)
     * @param icId  (optional)
     * @return V1AstroTarget
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroTarget(id: java.util.UUID? = null, ngcId: kotlin.String? = null, icId: kotlin.String? = null) : V1AstroTarget {
        val localVarResponse = v1GetAstroTargetWithHttpInfo(id = id, ngcId = ngcId, icId = icId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1AstroTarget
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get an astro target. Pass in an ID, an NGC ID or an IC ID.
     * @param id  (optional)
     * @param ngcId  (optional)
     * @param icId  (optional)
     * @return ApiResponse<V1AstroTarget?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroTargetWithHttpInfo(id: java.util.UUID?, ngcId: kotlin.String?, icId: kotlin.String?) : ApiResponse<V1AstroTarget?> {
        val localVariableConfig = v1GetAstroTargetRequestConfig(id = id, ngcId = ngcId, icId = icId)

        return request<Unit, V1AstroTarget>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroTarget
     *
     * @param id  (optional)
     * @param ngcId  (optional)
     * @param icId  (optional)
     * @return RequestConfig
     */
    fun v1GetAstroTargetRequestConfig(id: java.util.UUID?, ngcId: kotlin.String?, icId: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (id != null) {
                    put("id", listOf(id.toString()))
                }
                if (ngcId != null) {
                    put("ngcId", listOf(ngcId.toString()))
                }
                if (icId != null) {
                    put("icId", listOf(icId.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-target",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get all astro targets. This response is paginated. It will only return at most 100 at a time. To get the next page, pass in the &#x60;id&#x60; of the last target in the current page as the &#x60;lastId&#x60; query parameter. Omitting this field fetches the first page.
     * @param lastId  (optional)
     * @param catalogId  (optional)
     * @param ra  (optional)
     * @param dec  (optional)
     * @return kotlin.collections.List<V1AstroTarget>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetAstroTargets(lastId: java.util.UUID? = null, catalogId: kotlin.String? = null, ra: kotlin.Double? = null, dec: kotlin.Double? = null) : kotlin.collections.List<V1AstroTarget> {
        val localVarResponse = v1GetAstroTargetsWithHttpInfo(lastId = lastId, catalogId = catalogId, ra = ra, dec = dec)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1AstroTarget>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get all astro targets. This response is paginated. It will only return at most 100 at a time. To get the next page, pass in the &#x60;id&#x60; of the last target in the current page as the &#x60;lastId&#x60; query parameter. Omitting this field fetches the first page.
     * @param lastId  (optional)
     * @param catalogId  (optional)
     * @param ra  (optional)
     * @param dec  (optional)
     * @return ApiResponse<kotlin.collections.List<V1AstroTarget>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetAstroTargetsWithHttpInfo(lastId: java.util.UUID?, catalogId: kotlin.String?, ra: kotlin.Double?, dec: kotlin.Double?) : ApiResponse<kotlin.collections.List<V1AstroTarget>?> {
        val localVariableConfig = v1GetAstroTargetsRequestConfig(lastId = lastId, catalogId = catalogId, ra = ra, dec = dec)

        return request<Unit, kotlin.collections.List<V1AstroTarget>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetAstroTargets
     *
     * @param lastId  (optional)
     * @param catalogId  (optional)
     * @param ra  (optional)
     * @param dec  (optional)
     * @return RequestConfig
     */
    fun v1GetAstroTargetsRequestConfig(lastId: java.util.UUID?, catalogId: kotlin.String?, ra: kotlin.Double?, dec: kotlin.Double?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (lastId != null) {
                    put("lastId", listOf(lastId.toString()))
                }
                if (catalogId != null) {
                    put("catalogId", listOf(catalogId.toString()))
                }
                if (ra != null) {
                    put("ra", listOf(ra.toString()))
                }
                if (dec != null) {
                    put("dec", listOf(dec.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-targets",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get calibration masters.
     * @param nodeId 
     * @return kotlin.collections.List<V1CalibrationMaster>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetCalibrationMasters(nodeId: java.util.UUID) : kotlin.collections.List<V1CalibrationMaster> {
        val localVarResponse = v1GetCalibrationMastersWithHttpInfo(nodeId = nodeId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1CalibrationMaster>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get calibration masters.
     * @param nodeId 
     * @return ApiResponse<kotlin.collections.List<V1CalibrationMaster>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetCalibrationMastersWithHttpInfo(nodeId: java.util.UUID) : ApiResponse<kotlin.collections.List<V1CalibrationMaster>?> {
        val localVariableConfig = v1GetCalibrationMastersRequestConfig(nodeId = nodeId)

        return request<Unit, kotlin.collections.List<V1CalibrationMaster>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetCalibrationMasters
     *
     * @param nodeId 
     * @return RequestConfig
     */
    fun v1GetCalibrationMastersRequestConfig(nodeId: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("nodeId", listOf(nodeId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/calibration-masters",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get cameras.
     * @return kotlin.collections.List<V1Camera>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetCameras() : kotlin.collections.List<V1Camera> {
        val localVarResponse = v1GetCamerasWithHttpInfo()

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1Camera>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get cameras.
     * @return ApiResponse<kotlin.collections.List<V1Camera>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetCamerasWithHttpInfo() : ApiResponse<kotlin.collections.List<V1Camera>?> {
        val localVariableConfig = v1GetCamerasRequestConfig()

        return request<Unit, kotlin.collections.List<V1Camera>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetCameras
     *
     * @return RequestConfig
     */
    fun v1GetCamerasRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/cameras",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get an image set.
     * @param id 
     * @return V1ImageSet
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetImageSet(id: java.util.UUID) : V1ImageSet {
        val localVarResponse = v1GetImageSetWithHttpInfo(id = id)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1ImageSet
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get an image set.
     * @param id 
     * @return ApiResponse<V1ImageSet?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetImageSetWithHttpInfo(id: java.util.UUID) : ApiResponse<V1ImageSet?> {
        val localVariableConfig = v1GetImageSetRequestConfig(id = id)

        return request<Unit, V1ImageSet>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetImageSet
     *
     * @param id 
     * @return RequestConfig
     */
    fun v1GetImageSetRequestConfig(id: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("id", listOf(id.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/image-set",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get an image.
     * @param imageId 
     * @return V1ImageSetImage
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetImageSetImage(imageId: java.util.UUID) : V1ImageSetImage {
        val localVarResponse = v1GetImageSetImageWithHttpInfo(imageId = imageId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1ImageSetImage
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get an image.
     * @param imageId 
     * @return ApiResponse<V1ImageSetImage?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetImageSetImageWithHttpInfo(imageId: java.util.UUID) : ApiResponse<V1ImageSetImage?> {
        val localVariableConfig = v1GetImageSetImageRequestConfig(imageId = imageId)

        return request<Unit, V1ImageSetImage>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetImageSetImage
     *
     * @param imageId 
     * @return RequestConfig
     */
    fun v1GetImageSetImageRequestConfig(imageId: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("imageId", listOf(imageId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/image-set-image",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get image set images.
     * @param imageSets 
     * @return kotlin.collections.List<V1ImageSetImage>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetImageSetImages(imageSets: kotlin.collections.List<java.util.UUID>) : kotlin.collections.List<V1ImageSetImage> {
        val localVarResponse = v1GetImageSetImagesWithHttpInfo(imageSets = imageSets)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1ImageSetImage>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get image set images.
     * @param imageSets 
     * @return ApiResponse<kotlin.collections.List<V1ImageSetImage>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetImageSetImagesWithHttpInfo(imageSets: kotlin.collections.List<java.util.UUID>) : ApiResponse<kotlin.collections.List<V1ImageSetImage>?> {
        val localVariableConfig = v1GetImageSetImagesRequestConfig(imageSets = imageSets)

        return request<Unit, kotlin.collections.List<V1ImageSetImage>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetImageSetImages
     *
     * @param imageSets 
     * @return RequestConfig
     */
    fun v1GetImageSetImagesRequestConfig(imageSets: kotlin.collections.List<java.util.UUID>) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("imageSets", toMultiValue(imageSets.toList(), "csv"))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/image-set-images",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get image sets.
     * @return kotlin.collections.List<V1ImageSet>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetImageSets() : kotlin.collections.List<V1ImageSet> {
        val localVarResponse = v1GetImageSetsWithHttpInfo()

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1ImageSet>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get image sets.
     * @return ApiResponse<kotlin.collections.List<V1ImageSet>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetImageSetsWithHttpInfo() : ApiResponse<kotlin.collections.List<V1ImageSet>?> {
        val localVariableConfig = v1GetImageSetsRequestConfig()

        return request<Unit, kotlin.collections.List<V1ImageSet>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetImageSets
     *
     * @return RequestConfig
     */
    fun v1GetImageSetsRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/image-sets",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get job logs.
     * @param astroProjectId 
     * @return kotlin.collections.List<V1JobLog>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetJobLogs(astroProjectId: java.util.UUID) : kotlin.collections.List<V1JobLog> {
        val localVarResponse = v1GetJobLogsWithHttpInfo(astroProjectId = astroProjectId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1JobLog>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get job logs.
     * @param astroProjectId 
     * @return ApiResponse<kotlin.collections.List<V1JobLog>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetJobLogsWithHttpInfo(astroProjectId: java.util.UUID) : ApiResponse<kotlin.collections.List<V1JobLog>?> {
        val localVariableConfig = v1GetJobLogsRequestConfig(astroProjectId = astroProjectId)

        return request<Unit, kotlin.collections.List<V1JobLog>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetJobLogs
     *
     * @param astroProjectId 
     * @return RequestConfig
     */
    fun v1GetJobLogsRequestConfig(astroProjectId: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("astroProjectId", listOf(astroProjectId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/job-logs",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get nodes.
     * @return V1GetNodes
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetNodes() : V1GetNodes {
        val localVarResponse = v1GetNodesWithHttpInfo()

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1GetNodes
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get nodes.
     * @return ApiResponse<V1GetNodes?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetNodesWithHttpInfo() : ApiResponse<V1GetNodes?> {
        val localVariableConfig = v1GetNodesRequestConfig()

        return request<Unit, V1GetNodes>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetNodes
     *
     * @return RequestConfig
     */
    fun v1GetNodesRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/nodes",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get or create camera.
     * @param v1GetOrCreateCameraRequest 
     * @return V1Camera
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetOrCreateCamera(v1GetOrCreateCameraRequest: V1GetOrCreateCameraRequest) : V1Camera {
        val localVarResponse = v1GetOrCreateCameraWithHttpInfo(v1GetOrCreateCameraRequest = v1GetOrCreateCameraRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1Camera
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get or create camera.
     * @param v1GetOrCreateCameraRequest 
     * @return ApiResponse<V1Camera?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetOrCreateCameraWithHttpInfo(v1GetOrCreateCameraRequest: V1GetOrCreateCameraRequest) : ApiResponse<V1Camera?> {
        val localVariableConfig = v1GetOrCreateCameraRequestConfig(v1GetOrCreateCameraRequest = v1GetOrCreateCameraRequest)

        return request<V1GetOrCreateCameraRequest, V1Camera>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetOrCreateCamera
     *
     * @param v1GetOrCreateCameraRequest 
     * @return RequestConfig
     */
    fun v1GetOrCreateCameraRequestConfig(v1GetOrCreateCameraRequest: V1GetOrCreateCameraRequest) : RequestConfig<V1GetOrCreateCameraRequest> {
        val localVariableBody = v1GetOrCreateCameraRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/v1/camera-match",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get or create mount.
     * @param v1GetOrCreateMountRequest 
     * @return V1Mount
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetOrCreateMount(v1GetOrCreateMountRequest: V1GetOrCreateMountRequest) : V1Mount {
        val localVarResponse = v1GetOrCreateMountWithHttpInfo(v1GetOrCreateMountRequest = v1GetOrCreateMountRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1Mount
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get or create mount.
     * @param v1GetOrCreateMountRequest 
     * @return ApiResponse<V1Mount?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetOrCreateMountWithHttpInfo(v1GetOrCreateMountRequest: V1GetOrCreateMountRequest) : ApiResponse<V1Mount?> {
        val localVariableConfig = v1GetOrCreateMountRequestConfig(v1GetOrCreateMountRequest = v1GetOrCreateMountRequest)

        return request<V1GetOrCreateMountRequest, V1Mount>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetOrCreateMount
     *
     * @param v1GetOrCreateMountRequest 
     * @return RequestConfig
     */
    fun v1GetOrCreateMountRequestConfig(v1GetOrCreateMountRequest: V1GetOrCreateMountRequest) : RequestConfig<V1GetOrCreateMountRequest> {
        val localVariableBody = v1GetOrCreateMountRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/v1/mount-match",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get or create optical tube.
     * @param v1GetOrCreateOpticalTubeRequest 
     * @return V1OpticalTube
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetOrCreateOpticalTube(v1GetOrCreateOpticalTubeRequest: V1GetOrCreateOpticalTubeRequest) : V1OpticalTube {
        val localVarResponse = v1GetOrCreateOpticalTubeWithHttpInfo(v1GetOrCreateOpticalTubeRequest = v1GetOrCreateOpticalTubeRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as V1OpticalTube
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get or create optical tube.
     * @param v1GetOrCreateOpticalTubeRequest 
     * @return ApiResponse<V1OpticalTube?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetOrCreateOpticalTubeWithHttpInfo(v1GetOrCreateOpticalTubeRequest: V1GetOrCreateOpticalTubeRequest) : ApiResponse<V1OpticalTube?> {
        val localVariableConfig = v1GetOrCreateOpticalTubeRequestConfig(v1GetOrCreateOpticalTubeRequest = v1GetOrCreateOpticalTubeRequest)

        return request<V1GetOrCreateOpticalTubeRequest, V1OpticalTube>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetOrCreateOpticalTube
     *
     * @param v1GetOrCreateOpticalTubeRequest 
     * @return RequestConfig
     */
    fun v1GetOrCreateOpticalTubeRequestConfig(v1GetOrCreateOpticalTubeRequest: V1GetOrCreateOpticalTubeRequest) : RequestConfig<V1GetOrCreateOpticalTubeRequest> {
        val localVariableBody = v1GetOrCreateOpticalTubeRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/v1/optical-tube-match",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Get platform credits.
     * @return kotlin.collections.List<V1PlatformCredit>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1GetPlatformCredits() : kotlin.collections.List<V1PlatformCredit> {
        val localVarResponse = v1GetPlatformCreditsWithHttpInfo()

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1PlatformCredit>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Get platform credits.
     * @return ApiResponse<kotlin.collections.List<V1PlatformCredit>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1GetPlatformCreditsWithHttpInfo() : ApiResponse<kotlin.collections.List<V1PlatformCredit>?> {
        val localVariableConfig = v1GetPlatformCreditsRequestConfig()

        return request<Unit, kotlin.collections.List<V1PlatformCredit>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1GetPlatformCredits
     *
     * @return RequestConfig
     */
    fun v1GetPlatformCreditsRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/platform-credits",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Match astro project.
     * @param targetId 
     * @param cameraId 
     * @param otaId 
     * @return kotlin.collections.List<V1AstroProject>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1MatchAstroProject(targetId: java.util.UUID, cameraId: java.util.UUID, otaId: java.util.UUID) : kotlin.collections.List<V1AstroProject> {
        val localVarResponse = v1MatchAstroProjectWithHttpInfo(targetId = targetId, cameraId = cameraId, otaId = otaId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1AstroProject>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Match astro project.
     * @param targetId 
     * @param cameraId 
     * @param otaId 
     * @return ApiResponse<kotlin.collections.List<V1AstroProject>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1MatchAstroProjectWithHttpInfo(targetId: java.util.UUID, cameraId: java.util.UUID, otaId: java.util.UUID) : ApiResponse<kotlin.collections.List<V1AstroProject>?> {
        val localVariableConfig = v1MatchAstroProjectRequestConfig(targetId = targetId, cameraId = cameraId, otaId = otaId)

        return request<Unit, kotlin.collections.List<V1AstroProject>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1MatchAstroProject
     *
     * @param targetId 
     * @param cameraId 
     * @param otaId 
     * @return RequestConfig
     */
    fun v1MatchAstroProjectRequestConfig(targetId: java.util.UUID, cameraId: java.util.UUID, otaId: java.util.UUID) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("targetId", listOf(targetId.toString()))
                put("cameraId", listOf(cameraId.toString()))
                put("otaId", listOf(otaId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/astro-project-match",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Match mount.
     * @param model  (optional)
     * @return kotlin.collections.List<V1Mount>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1MountMatch(model: kotlin.String? = null) : kotlin.collections.List<V1Mount> {
        val localVarResponse = v1MountMatchWithHttpInfo(model = model)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1Mount>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Match mount.
     * @param model  (optional)
     * @return ApiResponse<kotlin.collections.List<V1Mount>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1MountMatchWithHttpInfo(model: kotlin.String?) : ApiResponse<kotlin.collections.List<V1Mount>?> {
        val localVariableConfig = v1MountMatchRequestConfig(model = model)

        return request<Unit, kotlin.collections.List<V1Mount>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1MountMatch
     *
     * @param model  (optional)
     * @return RequestConfig
     */
    fun v1MountMatchRequestConfig(model: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (model != null) {
                    put("model", listOf(model.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/mount-match",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Match optical tube.
     * @param model  (optional)
     * @param focalLengthMm  (optional)
     * @param apertureMm  (optional)
     * @return kotlin.collections.List<V1OpticalTube>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1OpticalTubeMatch(model: kotlin.String? = null, focalLengthMm: kotlin.Int? = null, apertureMm: kotlin.Int? = null) : kotlin.collections.List<V1OpticalTube> {
        val localVarResponse = v1OpticalTubeMatchWithHttpInfo(model = model, focalLengthMm = focalLengthMm, apertureMm = apertureMm)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<V1OpticalTube>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Match optical tube.
     * @param model  (optional)
     * @param focalLengthMm  (optional)
     * @param apertureMm  (optional)
     * @return ApiResponse<kotlin.collections.List<V1OpticalTube>?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1OpticalTubeMatchWithHttpInfo(model: kotlin.String?, focalLengthMm: kotlin.Int?, apertureMm: kotlin.Int?) : ApiResponse<kotlin.collections.List<V1OpticalTube>?> {
        val localVariableConfig = v1OpticalTubeMatchRequestConfig(model = model, focalLengthMm = focalLengthMm, apertureMm = apertureMm)

        return request<Unit, kotlin.collections.List<V1OpticalTube>>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1OpticalTubeMatch
     *
     * @param model  (optional)
     * @param focalLengthMm  (optional)
     * @param apertureMm  (optional)
     * @return RequestConfig
     */
    fun v1OpticalTubeMatchRequestConfig(model: kotlin.String?, focalLengthMm: kotlin.Int?, apertureMm: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (model != null) {
                    put("model", listOf(model.toString()))
                }
                if (focalLengthMm != null) {
                    put("focalLengthMm", listOf(focalLengthMm.toString()))
                }
                if (apertureMm != null) {
                    put("apertureMm", listOf(apertureMm.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/optical-tube-match",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Stack an astro project.
     * @param v1PutStackAstroProjectRequest 
     * @return EmptySuccess
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1PutStackAstroProject(v1PutStackAstroProjectRequest: V1PutStackAstroProjectRequest) : EmptySuccess {
        val localVarResponse = v1PutStackAstroProjectWithHttpInfo(v1PutStackAstroProjectRequest = v1PutStackAstroProjectRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptySuccess
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Stack an astro project.
     * @param v1PutStackAstroProjectRequest 
     * @return ApiResponse<EmptySuccess?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1PutStackAstroProjectWithHttpInfo(v1PutStackAstroProjectRequest: V1PutStackAstroProjectRequest) : ApiResponse<EmptySuccess?> {
        val localVariableConfig = v1PutStackAstroProjectRequestConfig(v1PutStackAstroProjectRequest = v1PutStackAstroProjectRequest)

        return request<V1PutStackAstroProjectRequest, EmptySuccess>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1PutStackAstroProject
     *
     * @param v1PutStackAstroProjectRequest 
     * @return RequestConfig
     */
    fun v1PutStackAstroProjectRequestConfig(v1PutStackAstroProjectRequest: V1PutStackAstroProjectRequest) : RequestConfig<V1PutStackAstroProjectRequest> {
        val localVariableBody = v1PutStackAstroProjectRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/v1/stack-astro-project",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * 
     * Update a node.
     * @param v1UpdateNodeRequest 
     * @return EmptySuccess
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun v1UpdateNode(v1UpdateNodeRequest: V1UpdateNodeRequest) : EmptySuccess {
        val localVarResponse = v1UpdateNodeWithHttpInfo(v1UpdateNodeRequest = v1UpdateNodeRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptySuccess
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * Update a node.
     * @param v1UpdateNodeRequest 
     * @return ApiResponse<EmptySuccess?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun v1UpdateNodeWithHttpInfo(v1UpdateNodeRequest: V1UpdateNodeRequest) : ApiResponse<EmptySuccess?> {
        val localVariableConfig = v1UpdateNodeRequestConfig(v1UpdateNodeRequest = v1UpdateNodeRequest)

        return request<V1UpdateNodeRequest, EmptySuccess>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation v1UpdateNode
     *
     * @param v1UpdateNodeRequest 
     * @return RequestConfig
     */
    fun v1UpdateNodeRequestConfig(v1UpdateNodeRequest: V1UpdateNodeRequest) : RequestConfig<V1UpdateNodeRequest> {
        val localVariableBody = v1UpdateNodeRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/v1/node",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
