package ai.passio.passiosdk.core.authentication

import ai.passio.passiosdk.core.utils.getBooleanOptional
import ai.passio.passiosdk.core.utils.getObjectOptional
import org.json.JSONObject

internal class ConfigurationsFile(json: String) : JSONObject(json) {
    val key1: String = this.getString("key1")
    val key2: String = this.getString("key2")
    val url: String = this.getString("url")
}

internal class TrialMode(json: String) : JSONObject(json) {
    val timeSpent: Boolean? = this.getBooleanOptional("timeSpent")
    val foundPassioIDs: Boolean? = this.getBooleanOptional("foundPassioIDs")
    val enabled: Boolean? = this.getBooleanOptional("enabled")
    val photos: Boolean? = this.getBooleanOptional("photos")
}

internal class RemodelAR(json: String) : JSONObject(json) {
    val enabled = this.getBoolean("enabled")
}

internal class AirFryer(json: String) : JSONObject(json) {
    val enabled = this.getBoolean("enabled")
    val nutritionDB = this.getBooleanOptional("nutritionDB")
    val openfoodDB = this.getBooleanOptional("openfoodDB")
    val volume = this.getBooleanOptional("volume")
    val amount = this.getBooleanOptional("amount")
}

internal class Fridge(json: String) : JSONObject(json) {
    val enabled = this.getBoolean("enabled")
    val nutritionDB = this.getBooleanOptional("nutritionDB")
    val openfoodDB = this.getBooleanOptional("openfoodDB")
    val barcode = this.getBooleanOptional("barcode")
    val packagedFood = this.getBooleanOptional("packagedFood")
}

internal class Construction(json: String) : JSONObject(json) {
    val enabled = this.getBoolean("enabled")
}

internal class Nutrition(json: String) : JSONObject(json) {
    val enabled = this.getBoolean("enabled")
    val nutritionDB = this.getBooleanOptional("nutritionDB")
    val openfoodDB = this.getBooleanOptional("openfoodDB")
    val barcode = this.getBooleanOptional("barcode")
    val packagedFood = this.getBooleanOptional("packagedFood")
    val volume = this.getBooleanOptional("volume")
    val amount = this.getBooleanOptional("amount")
}

internal class Platform(json: String): JSONObject(json) {
    val enabled = this.getBoolean("enabled")
}

internal class Projects(json: String) : JSONObject(json) {
    val remodelAR = getObjectOptional(this, "remodelAR", ::RemodelAR)
    val airFryer = getObjectOptional(this, "airfryer", ::AirFryer)
    val fridge = getObjectOptional(this, "fridge", ::Fridge)
    val construction = getObjectOptional(this, "fridge", ::Construction)
    val nutrition = getObjectOptional(this, "nutrition", ::Nutrition)
    val platform = getObjectOptional(this, "platform", ::Platform)
}

internal class LicenseConfiguration(private val json: String) : JSONObject(json) {
    val configurationsFile = ConfigurationsFile(this.getJSONObject("configurationsFile").toString())
    val until: String = this.getString("until")
    val trialMode = TrialMode(this.getJSONObject("trialMode").toString())
    val daysToCheckLicense = this.getInt("daysToCheckLicense")
    val projects = Projects(this.getJSONObject("projects").toString())
    val developer: String = this.getString("developer")

    override fun toString(): String {
        return json
    }
}