package ai.passio.passiosdk.core.ocr;

import androidx.annotation.Keep;

import java.io.Serializable;

class JavaSerializer {

    @Keep
    class OcrVectorizeModel implements Serializable {

        private static final long serialVersionUID = 6529685098267757690L;

        private float[] weights = null;
        private String[] upcs = null;
        private String[] names = null;
        private Matrix[] matrix = null;
        private VocabItem[] vocab;

        public float[] getWeights() {
            return weights;
        }

        public String[] getUpcs() {
            return upcs;
        }

        public String[] getNames() {
            return names;
        }

        public Matrix[] getMatrix() {
            return matrix;
        }

        public VocabItem[] getVocab() {
            return vocab;
        }

        protected float[] getMatrixElementAt(int index) {
            float r = matrix[index].getR();
            float c = matrix[index].getC();
            float v = matrix[index].getV();
            return new float[]{r, c, v};
        }

        protected int getMatrixSize() {
            return matrix.length;
        }

        protected String getVocabNGramAt(int index) {
            return vocab[index].getNgram();
        }

        protected int getVocabIndexAt(int index) {
            return vocab[index].getIndex();
        }

        protected int getVocabSize() {
            return vocab.length;
        }
    }

    @Keep
    class VocabItem implements Serializable {

        private static final long serialVersionUID = 8889685098567756911L;

        private String ngram;
        private int index;

        public void setNgram(final String ngram) {
            this.ngram = ngram;
        }

        public void setIndex(final int index) {
            this.index = index;
        }

        public String getNgram() {
            return ngram;
        }

        public int getIndex() {
            return index;
        }
    }

    @Keep
    class Matrix implements Serializable {

        private static final long serialVersionUID = 6549685098567756911L;

        private int r;
        private int c;
        private float v;

        public int getR() {
            return r;
        }

        public int getC() {
            return c;
        }

        public float getV() {
            return v;
        }
    }
}
