package ai.passio.passiosdk.core.sharedpreferences

import android.content.Context
import java.util.Random

internal class DeviceIDPreferencesManager(context: Context) : CorePreferencesManager(context) {

    companion object Key {
        private const val DEVICE_ID = "deviceId"
    }

    fun getDeviceID(): String? {
        return sharedPreferences.getString(DEVICE_ID, null)
    }

    fun setDeviceID(deviceID: String) {
        sharedPreferences.edit().putString(DEVICE_ID, deviceID).apply()
    }

    fun generateRandomID(length: Int): String {
        val SALTCHARS = "abcdefghijklmnopqrstuvwxyz1234567890"
        val salt = StringBuilder()
        val rnd = Random()
        for (i in 0 until length) {
            salt.append(SALTCHARS[rnd.nextInt(SALTCHARS.length)])
        }
        return salt.toString()
    }
}