package ai.passio.passiosdk.passiofood.data.model

import ai.passio.passiosdk.passiofood.data.measurement.Grams
import ai.passio.passiosdk.passiofood.data.measurement.Unit
import ai.passio.passiosdk.passiofood.data.measurement.UnitEnergy
import ai.passio.passiosdk.passiofood.data.measurement.UnitMass
import ai.passio.passiosdk.passiofood.upc.ResponseNutrient
import kotlin.reflect.KClass
import kotlin.reflect.KMutableProperty0

data class PassioNutrients internal constructor(val weight: UnitMass) {

    var referenceWeight = UnitMass(Grams, 100.0)

    private var refAlcohol: UnitMass? = null
    private var refCalcium: UnitMass? = null
    private var refCalories: UnitEnergy? = null
    private var refCarbs: UnitMass? = null
    private var refCholesterol: UnitMass? = null
    private var refChromium: UnitMass? = null
    private var refFibers: UnitMass? = null
    private var refFolicAcid: UnitMass? = null
    private var refFat: UnitMass? = null
    private var refIron: UnitMass? = null
    private var refIodine: UnitMass? = null
    private var refMagnesium: UnitMass? = null
    private var refMonounsaturatedFat: UnitMass? = null
    private var refPhosphorus: UnitMass? = null
    private var refPolyunsaturatedFat: UnitMass? = null
    private var refPotassium: UnitMass? = null
    private var refProteins: UnitMass? = null
    private var refSatFat: UnitMass? = null
    private var refSelenium: UnitMass? = null
    private var refSodium: UnitMass? = null
    private var refSugars: UnitMass? = null
    private var refSugarsAdded: UnitMass? = null
    private var refSugarAlcohol: UnitMass? = null
    private var refTransFat: UnitMass? = null
    private var refVitaminA: Double? = null
    private var refVitaminARAE: UnitMass? = null
    private var refVitaminB6: UnitMass? = null
    private var refVitaminB12: UnitMass? = null
    private var refVitaminB12Added: UnitMass? = null
    private var refVitaminC: UnitMass? = null
    private var refVitaminD: UnitMass? = null
    private var refVitaminE: UnitMass? = null
    private var refVitaminEAdded: UnitMass? = null
    private var refVitaminKPhylloquinone: UnitMass? = null
    private var refVitaminKMenaquinone4: UnitMass? = null
    private var refVitaminKDihydrophylloquinone: UnitMass? = null
    private var refZinc: UnitMass? = null

    fun fat(): UnitMass? = scaleValueByAmount(::refFat)
    fun calories(): UnitEnergy? = scaleValueByAmount(refCalories)
    fun protein(): UnitMass? = scaleValueByAmount(::refProteins)
    fun carbs(): UnitMass? = scaleValueByAmount(::refCarbs)
    fun satFat(): UnitMass? = scaleValueByAmount(::refSatFat)
    fun monounsaturatedFat(): UnitMass? = scaleValueByAmount(::refMonounsaturatedFat)
    fun polyunsaturatedFat(): UnitMass? = scaleValueByAmount(::refPolyunsaturatedFat)
    fun cholesterol(): UnitMass? = scaleValueByAmount(::refCholesterol)
    fun sodium(): UnitMass? = scaleValueByAmount(::refSodium)
    fun fibers(): UnitMass? = scaleValueByAmount(::refFibers)
    fun transFat(): UnitMass? = scaleValueByAmount(::refTransFat)
    fun sugars(): UnitMass? = scaleValueByAmount(::refSugars)
    fun sugarsAdded(): UnitMass? = scaleValueByAmount(::refSugarsAdded)
    fun alcohol(): UnitMass? = scaleValueByAmount(::refAlcohol)
    fun iron(): UnitMass? = scaleValueByAmount(::refIron)
    fun vitaminC(): UnitMass? = scaleValueByAmount(::refVitaminC)
    fun vitaminA(): Double? = scaleValueByAmount(refVitaminA)
    fun vitaminD(): UnitMass? = scaleValueByAmount(::refVitaminD)
    fun vitaminB6(): UnitMass? = scaleValueByAmount(::refVitaminB6)
    fun vitaminB12(): UnitMass? = scaleValueByAmount(::refVitaminB12)
    fun calcium(): UnitMass? = scaleValueByAmount(::refCalcium)
    fun potassium(): UnitMass? = scaleValueByAmount(::refPotassium)
    fun magnesium(): UnitMass? = scaleValueByAmount(::refMagnesium)
    fun phosphorus(): UnitMass? = scaleValueByAmount(::refPhosphorus)
    fun sugarAlcohol(): UnitMass? = scaleValueByAmount(::refSugarAlcohol)
    fun vitaminB12Added(): UnitMass? = scaleValueByAmount(::refVitaminB12Added)
    fun vitaminE(): UnitMass? = scaleValueByAmount(::refVitaminE)
    fun vitaminEAdded(): UnitMass? = scaleValueByAmount(::refVitaminEAdded)
    fun iodine(): UnitMass? = scaleValueByAmount(::refIodine)
    fun zinc(): UnitMass? = scaleValueByAmount(::refZinc)
    fun selenium(): UnitMass? = scaleValueByAmount(::refSelenium)
    fun folicAcid(): UnitMass? = scaleValueByAmount(::refFolicAcid)
    fun vitaminKPhylloquinone(): UnitMass? = scaleValueByAmount(::refVitaminKPhylloquinone)
    fun chromium(): UnitMass? = scaleValueByAmount(::refChromium)
    fun vitaminKMenaquinone4(): UnitMass? = scaleValueByAmount(::refVitaminKMenaquinone4)
    fun vitaminKDihydrophylloquinone(): UnitMass? =
        scaleValueByAmount(::refVitaminKDihydrophylloquinone)
    fun vitaminARAE(): UnitMass? = scaleValueByAmount(::refVitaminARAE)

    private fun scaleValueByAmount(field: KMutableProperty0<UnitMass?>): UnitMass? {
        if (field.get() == null) {
            return null
        }

        return field.get()!! * (weight.gramsValue() / referenceWeight.gramsValue())
    }

    private fun scaleValueByAmount(unitEnergy: UnitEnergy?): UnitEnergy? {
        if (unitEnergy == null) {
            return null
        }

        return unitEnergy * (weight.gramsValue() / referenceWeight.gramsValue())
    }

    private fun scaleValueByAmount(value: Double?): Double? {
        if (value == null) return null

        return value * (weight.gramsValue() / referenceWeight.gramsValue())
    }

    constructor(
        referenceNutrients: PassioNutrients,
        weight: UnitMass = UnitMass(Grams, 100.0)
    ) : this(weight) {
        refFat = referenceNutrients.refFat
        refSatFat = referenceNutrients.refSatFat
        refMonounsaturatedFat = referenceNutrients.refMonounsaturatedFat
        refPolyunsaturatedFat = referenceNutrients.refPolyunsaturatedFat
        refProteins = referenceNutrients.refProteins
        refCarbs = referenceNutrients.refCarbs
        refCalories = referenceNutrients.refCalories
        refCholesterol = referenceNutrients.refCholesterol
        refSodium = referenceNutrients.refSodium
        refFibers = referenceNutrients.refFibers
        refTransFat = referenceNutrients.refTransFat
        refSugars = referenceNutrients.refSugars
        refSugarsAdded = referenceNutrients.refSugarsAdded
        refAlcohol = referenceNutrients.refAlcohol
        refIron = referenceNutrients.refIron
        refVitaminC = referenceNutrients.refVitaminC
        refVitaminD = referenceNutrients.refVitaminD
        refVitaminB6 = referenceNutrients.refVitaminB6
        refVitaminB12 = referenceNutrients.refVitaminB12
        refVitaminB12Added = referenceNutrients.refVitaminB12Added
        refVitaminE = referenceNutrients.refVitaminE
        refVitaminEAdded = referenceNutrients.refVitaminEAdded
        refIodine = referenceNutrients.refIodine
        refCalcium = referenceNutrients.refCalcium
        refPotassium = referenceNutrients.refPotassium
        refMagnesium = referenceNutrients.refMagnesium
        refPhosphorus = referenceNutrients.refPhosphorus
        refSugarAlcohol = referenceNutrients.refSugarAlcohol
        refVitaminA = referenceNutrients.refVitaminA
        refZinc = referenceNutrients.refZinc
        refSelenium = referenceNutrients.refSelenium
        refFolicAcid = referenceNutrients.refFolicAcid
        refVitaminKPhylloquinone = referenceNutrients.refVitaminKPhylloquinone
        refChromium = referenceNutrients.refChromium
        refVitaminKMenaquinone4 = referenceNutrients.refVitaminKMenaquinone4
        refVitaminKDihydrophylloquinone = referenceNutrients.refVitaminKDihydrophylloquinone
        refVitaminARAE = referenceNutrients.refVitaminARAE
    }

    constructor(
        ingredientsData: List<Pair<PassioNutrients, Double>>, weight: UnitMass
    ) : this(weight) {
        refFat = ingredientsData.map { it.first.refFat?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSatFat = ingredientsData.map { it.first.refSatFat?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refMonounsaturatedFat =
            ingredientsData.map { it.first.refMonounsaturatedFat?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refPolyunsaturatedFat =
            ingredientsData.map { it.first.refPolyunsaturatedFat?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refProteins = ingredientsData.map { it.first.refProteins?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCarbs = ingredientsData.map { it.first.refCarbs?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCholesterol = ingredientsData.map { it.first.refCholesterol?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSodium = ingredientsData.map { it.first.refSodium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refFibers = ingredientsData.map { it.first.refFibers?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refTransFat = ingredientsData.map { it.first.refTransFat?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSugars = ingredientsData.map { it.first.refSugars?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSugarsAdded = ingredientsData.map { it.first.refSugarsAdded?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refAlcohol = ingredientsData.map { it.first.refAlcohol?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refIron = ingredientsData.map { it.first.refIron?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminC = ingredientsData.map { it.first.refVitaminC?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminD = ingredientsData.map { it.first.refVitaminD?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminB6 = ingredientsData.map { it.first.refVitaminB6?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminB12 = ingredientsData.map { it.first.refVitaminB12?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminB12Added = ingredientsData.map { it.first.refVitaminB12Added?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminE = ingredientsData.map { it.first.refVitaminE?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminEAdded = ingredientsData.map { it.first.refVitaminEAdded?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refIodine = ingredientsData.map { it.first.refIodine?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCalcium = ingredientsData.map { it.first.refCalcium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refPotassium = ingredientsData.map { it.first.refPotassium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refMagnesium = ingredientsData.map { it.first.refMagnesium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refPhosphorus = ingredientsData.map { it.first.refPhosphorus?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSugarAlcohol = ingredientsData.map { it.first.refSugarAlcohol?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCalories = ingredientsData.map { it.first.refCalories?.times(it.second) }
            .reduce { acc, unitEnergy -> acc?.plus(unitEnergy) ?: unitEnergy }
        refVitaminA = ingredientsData.map { it.first.refVitaminA?.times(it.second) }
            .reduce { acc, value -> acc?.plus(value ?: 0.0) ?: value }
        refZinc = ingredientsData.map { it.first.refZinc?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSelenium = ingredientsData.map { it.first.refSelenium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refFolicAcid = ingredientsData.map { it.first.refFolicAcid?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminKPhylloquinone =
            ingredientsData.map { it.first.refVitaminKPhylloquinone?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refChromium = ingredientsData.map { it.first.refChromium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminKMenaquinone4 =
            ingredientsData.map { it.first.refVitaminKMenaquinone4?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminKDihydrophylloquinone =
            ingredientsData.map { it.first.refVitaminKDihydrophylloquinone?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminARAE = ingredientsData.map { it.first.refVitaminARAE?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
    }

    internal constructor(
        weight: UnitMass = UnitMass(Grams, 100.0),
        responseNutrients: List<ResponseNutrient>,
    ) : this(weight) {
        responseNutrients.forEach { upcNutrient ->
            val upcUnit = upcNutrient.nutrient?.unit ?: "g"
            val unit = Unit.unitFromString(upcUnit) ?: return@forEach
            val amount = upcNutrient.amount ?: 0.0

            if (upcNutrient.id == 1603211196548 || upcNutrient.nutrient?.shortName == "calories") {
                refCalories = UnitEnergy(unit, amount)
                return@forEach
            }

            if (upcNutrient.id == 1603211196594 || upcNutrient.nutrient?.shortName == "vitaminA") {
                refVitaminA = upcNutrient.amount
                return@forEach
            }

            val nutrientDefault = nutrientDefaults.firstOrNull { pn ->
                pn.id == upcNutrient.id || pn.shortName == upcNutrient.nutrient?.shortName
            } ?: return@forEach
            nutrientDefault.field.set(UnitMass(unit, amount))
        }
    }

    constructor(
        weight: UnitMass = UnitMass(value = 100.0),
        fat: UnitMass? = null,
        satFat: UnitMass? = null,
        monounsaturatedFat: UnitMass? = null,
        polyunsaturatedFat: UnitMass? = null,
        proteins: UnitMass? = null,
        carbs: UnitMass? = null,
        calories: UnitEnergy? = null,
        cholesterol: UnitMass? = null,
        sodium: UnitMass? = null,
        fibers: UnitMass? = null,
        transFat: UnitMass? = null,
        sugars: UnitMass? = null,
        sugarsAdded: UnitMass? = null,
        alcohol: UnitMass? = null,
        iron: UnitMass? = null,
        vitaminC: UnitMass? = null,
        vitaminD: UnitMass? = null,
        vitaminB6: UnitMass? = null,
        vitaminB12: UnitMass? = null,
        vitaminB12Added: UnitMass? = null,
        vitaminE: UnitMass? = null,
        vitaminEAdded: UnitMass? = null,
        iodine: UnitMass? = null,
        calcium: UnitMass? = null,
        potassium: UnitMass? = null,
        magnesium: UnitMass? = null,
        phosphorus: UnitMass? = null,
        sugarAlcohol: UnitMass? = null,
        vitaminA: Double? = null,
        vitaminARAE: UnitMass? = null,
    ) : this(UnitMass(Grams, 100.0)) {
        val ratio = 100 / weight.gramsValue()

        refFat = fat?.times(ratio)
        refSatFat = satFat?.times(ratio)
        refMonounsaturatedFat = monounsaturatedFat?.times(ratio)
        refPolyunsaturatedFat = polyunsaturatedFat?.times(ratio)
        refProteins = proteins?.times(ratio)
        refCarbs = carbs?.times(ratio)
        refCalories = calories?.times(ratio)
        refCholesterol = cholesterol?.times(ratio)
        refSodium = sodium?.times(ratio)
        refFibers = fibers?.times(ratio)
        refTransFat = transFat?.times(ratio)
        refSugars = sugars?.times(ratio)
        refSugarsAdded = sugarsAdded?.times(ratio)
        refAlcohol = alcohol?.times(ratio)
        refIron = iron?.times(ratio)
        refVitaminC = vitaminC?.times(ratio)
        refVitaminD = vitaminD?.times(ratio)
        refVitaminB6 = vitaminB6?.times(ratio)
        refVitaminB12 = vitaminB12?.times(ratio)
        refVitaminB12Added = vitaminB12Added?.times(ratio)
        refVitaminE = vitaminE?.times(ratio)
        refVitaminEAdded = vitaminEAdded?.times(ratio)
        refIodine = iodine?.times(ratio)
        refCalcium = calcium?.times(ratio)
        refPotassium = potassium?.times(ratio)
        refMagnesium = magnesium?.times(ratio)
        refPhosphorus = phosphorus?.times(ratio)
        refSugarAlcohol = sugarAlcohol?.times(ratio)
        refVitaminA = vitaminA?.times(ratio)
        refVitaminARAE = vitaminARAE?.times(ratio)
    }

    internal val nutrientDefaults = mutableListOf(
        PlatformNutrient(::refAlcohol, 1603211196555, "alcohol"),
        PlatformNutrient(::refCalcium, 1603211196577, "calcium"),
        // PlatformNutrient(::refCalories, 1603211196548, "calories"),
        PlatformNutrient(::refCarbs, 1603211196546, "carbs"),
        PlatformNutrient(::refCholesterol, 1603211196677, "cholesterol"),
        PlatformNutrient(::refChromium, 1603211196586, "chromium"),
        PlatformNutrient(::refFibers, 1603211196571, "fibers"),
        PlatformNutrient(::refFolicAcid, 1603211196640, "folicAcid"),
        PlatformNutrient(::refFat, 1603211196545, "fat"),
        PlatformNutrient(::refIron, 1603211196579, "iron"),
        PlatformNutrient(::refIodine, 1603211196590, "iodine"),
        PlatformNutrient(::refMagnesium, 1603211196580, "magnesium"),
        PlatformNutrient(::refMonounsaturatedFat, 1603211196709, "monounsaturatedFat"),
        PlatformNutrient(::refPhosphorus, 1603211196581, "phosphorus"),
        PlatformNutrient(::refPolyunsaturatedFat, 1603211196710, "polyunsaturatedFat"),
        PlatformNutrient(::refPotassium, 1603211196582, "potassium"),
        PlatformNutrient(::refProteins, 1603211196544, "protein"),
        PlatformNutrient(::refSatFat, 1603211196679, "satFat"),
        PlatformNutrient(::refSelenium, 1603211196593, "selenium"),
        PlatformNutrient(::refSodium, 1603211196583, "sodium"),
        PlatformNutrient(::refSugars, 1603211196751, "sugarTotal"),
        PlatformNutrient(::refSugarsAdded, 1603211196674, "sugarAdded"),
        PlatformNutrient(::refSugarAlcohol, 1603211196576, "sugarAlcohol"),
        PlatformNutrient(::refTransFat, 1603211196678, "transFat"),
        // PlatformNutrient(::refVitaminA, 1603211196594, "vitaminA"),
        PlatformNutrient(::refVitaminARAE, 1603211196596, "vitaminARAE"),
        PlatformNutrient(::refVitaminB6, 1603211196631, "vitaminB6"),
        PlatformNutrient(::refVitaminB12, 1603211196634, "vitaminB12"),
        PlatformNutrient(::refVitaminC, 1603211196626, "vitaminC"),
        PlatformNutrient(::refVitaminD, 1603211196604, "vitaminD"),
        PlatformNutrient(::refVitaminE, 1603211196599, "vitaminE"),
        PlatformNutrient(::refVitaminEAdded, 1603211196675, "vitaminEAdded"),
        PlatformNutrient(::refVitaminKPhylloquinone, 1603211196639, "vitaminKPhylloquinone"),
        PlatformNutrient(::refVitaminKMenaquinone4, 1603211196637, "vitaminKMenaquinone4"),
        PlatformNutrient(::refVitaminKDihydrophylloquinone, 1603211196638, "vitaminKDihydrophylloquinone"),
        PlatformNutrient(::refZinc, 1603211196585, "zinc"),
    )
}

internal data class PlatformNutrient(
    val field: KMutableProperty0<UnitMass?>,
    val id: Long,
    val shortName: String,
)