package ai.passio.passiosdk.passiofood.recognition

import ai.passio.passiosdk.core.config.SDKFileType
import ai.passio.passiosdk.core.ocr.KNNMatcher
import ai.passio.passiosdk.core.utils.PassioLog
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_HNN
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_HNN_ENv2
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_SSD_HNN
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_Yolo
import ai.passio.passiosdk.passiofood.config.passio_nutrition_HNN
import ai.passio.passiosdk.passiofood.config.passio_ocr_vectorize
import ai.passio.passiosdk.passiofood.file.PassioFoodFileManager
import ai.passio.passiosdk.passiofood.metadata.MetadataManager
import ai.passio.passiosdk.passiofood.mlkit.TextRecognitionFactory
import ai.passio.passiosdk.passiofood.tflite.TFLiteHNNKNNDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteObjectDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteYoloObjectDetector
import android.content.Context
import android.util.Size

internal class PassioAssetCompressedSecuredModelHolder(
    labelManager: MetadataManager,
    fileManager: PassioFoodFileManager
) : PassioModelHolder(labelManager, fileManager) {

    override fun initializeModel(
        context: Context,
        fileType: SDKFileType,
        version: Int
    ): Boolean {
        when (fileType) {
            passio_FoodNet_SSD_HNN -> {
                val modelName = "${passio_FoodNet_SSD_HNN.name}.$version.${getExtension()}"
                PassioLog.i(
                    PassioAssetCompressedSecuredModelHolder::
                    class.java.simpleName,
                    "Initializing $modelName"
                )

                val inputSize = Size(
                    PassioRecognizer.TF_OD_API_INPUT_SIZE,
                    PassioRecognizer.TF_OD_API_INPUT_SIZE
                )
                objectDetector = assetCatch(modelName) {
                    TFLiteObjectDetector(inputSize).apply {
                        createFromCompressedAssetModel(
                            context,
                            modelName,
                        )
                    }
                }

                return objectDetector != null
            }

            passio_FoodNet_HNN -> {
                val modelName = "${passio_FoodNet_HNN.name}.$version.${getExtension()}"
                PassioLog.i(
                    PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                    "Initializing $modelName"
                )
                val labels = labelManager.getVisualPassioIDs()
                val inputSize = Size(
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE,
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE
                )

                hnnDetector = assetCatch(modelName) {
                    TFLiteHNNKNNDetector(true, inputSize, labels).apply {
                        createFromCompressedAssetModel(
                            context,
                            modelName,
                        )
                    }
                }

                if (hnnDetector != null) {
                    PassioLog.i(
                        PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                        "$modelName init success"
                    )
                } else {
                    PassioLog.e(
                        PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                        "$modelName init failed"
                    )
                }

                return hnnDetector != null
            }

            passio_FoodNet_HNN_ENv2 -> {
                val modelName = "${passio_FoodNet_HNN_ENv2.name}.$version.${getExtension()}"
                PassioLog.i(
                    PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                    "Initializing $modelName"
                )
                val labels = labelManager.getVisualPassioIDs()
                val inputSize = Size(
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE,
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE
                )

                hnnDetector = assetCatch(modelName) {
                    TFLiteHNNKNNDetector(false, inputSize, labels).apply {
                        createFromCompressedAssetModel(
                            context,
                            modelName,
                        )
                    }
                }

                if (hnnDetector != null) {
                    PassioLog.i(
                        PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                        "$modelName init success"
                    )
                } else {
                    PassioLog.e(
                        PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                        "$modelName init failed"
                    )
                }

                return hnnDetector != null
            }

            passio_nutrition_HNN -> {
                return true
            }

            passio_ocr_vectorize -> {
                val modelName = "${passio_ocr_vectorize.name}.$version.${getExtension()}"
                PassioLog.i(
                    PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                    "Initializing $modelName"
                )

                ocrMatcher = assetCatch(modelName) {
                    KNNMatcher(
                        context,
                        modelName,
                    )
                }

                if (ocrMatcher == null) {
                    PassioLog.e(
                        PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                        "$modelName init failed"
                    )
                    return false
                }

                minOCRCharSize = context.resources.displayMetrics.heightPixels * 0.07f


                // Temporary fix for issue with incorrect class
                if (!ocrMatcher!!.isInitialized()) {
                    ocrMatcher = null
                    return false
                } else {
                    PassioLog.i(
                        PassioAssetCompressedSecuredModelHolder::class.java.simpleName,
                        "$modelName init success"
                    )
                }

                return true
            }

            passio_FoodNet_Yolo -> {
                val modelName = "${passio_FoodNet_Yolo.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val inputSize = Size(
                    PassioRecognizer.TF_YOLO_INPUT_SIZE,
                    PassioRecognizer.TF_YOLO_INPUT_SIZE
                )
                objectDetector = assetCatch(modelName) {
                    TFLiteYoloObjectDetector(inputSize).apply {
                        createFromCompressedAssetModel(
                            context,
                            modelName,
                        )
                    }
                }

                return objectDetector != null
            }

            else -> throw IllegalArgumentException("No known file type: ${fileType.name}")
        }
    }

    override fun getExtension(): String = "passiosecure2"
}