package ai.passio.passiosdk.passiofood.recognition

import ai.passio.passiosdk.core.config.SDKFileType
import ai.passio.passiosdk.core.ocr.KNNMatcher
import ai.passio.passiosdk.core.utils.PassioLog
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_HNN
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_HNN_ENv2
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_SSD_HNN
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_Yolo
import ai.passio.passiosdk.passiofood.config.passio_ocr_vectorize
import ai.passio.passiosdk.passiofood.file.PassioFoodFileManager
import ai.passio.passiosdk.passiofood.metadata.MetadataManager
import ai.passio.passiosdk.passiofood.mlkit.TextRecognitionFactory
import ai.passio.passiosdk.passiofood.tflite.TFLiteHNNKNNDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteObjectDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteYoloObjectDetector
import android.content.Context
import android.util.Size

internal class PassioExternalSecuredModelHolder(
    labelManager: MetadataManager,
    fileManager: PassioFoodFileManager
) : PassioModelHolder(labelManager, fileManager) {

    override fun initializeModel(
        context: Context,
        fileType: SDKFileType,
        version: Int,
    ): Boolean {
        when (fileType) {
            passio_FoodNet_SSD_HNN -> {
                val modelName = "${passio_FoodNet_SSD_HNN.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val odFile =
                    fileManager.getStoredFile(
                        context,
                        passio_FoodNet_SSD_HNN,
                        checkAlternatives = false
                    )
                if (odFile == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }
                val inputSize = Size(
                    PassioRecognizer.TF_OD_API_INPUT_SIZE,
                    PassioRecognizer.TF_OD_API_INPUT_SIZE
                )

                objectDetector = TFLiteObjectDetector(inputSize).apply {
                    createFromSecuredExternalModel(odFile)
                }

                return true
            }

            passio_FoodNet_HNN -> {
                val modelName = "${passio_FoodNet_HNN.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val hnnFile = fileManager.getStoredFile(
                    context,
                    passio_FoodNet_HNN,
                    checkAlternatives = false
                )
                if (hnnFile == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }

                val labels = labelManager.getVisualPassioIDs()
                val inputSize = Size(
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE,
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE
                )

                hnnDetector = TFLiteHNNKNNDetector(true, inputSize, labels).apply {
                    createFromSecuredExternalModel(hnnFile)
                }
                return true
            }

            passio_FoodNet_HNN_ENv2 -> {
                val modelName = "${passio_FoodNet_HNN_ENv2.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val hnnFile = fileManager.getStoredFile(
                    context,
                    passio_FoodNet_HNN_ENv2,
                    checkAlternatives = false
                )
                if (hnnFile == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }

                val labels = labelManager.getVisualPassioIDs()
                val inputSize = Size(
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE,
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE
                )

                hnnDetector = TFLiteHNNKNNDetector(false, inputSize, labels).apply {
                    createFromSecuredExternalModel(hnnFile)
                }
                return true
            }

            passio_ocr_vectorize -> {
                val modelName = "${passio_ocr_vectorize.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val vecFile = fileManager.getStoredFile(
                    context,
                    passio_ocr_vectorize,
                    checkAlternatives = false
                )
                if (vecFile == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }

                ocrMatcher = KNNMatcher(vecFile)

                // Temporary fix for issue with incorrect class
                if (!ocrMatcher!!.isInitialized()) {
                    ocrMatcher = null
                } else {
                    minOCRCharSize =
                        context.resources.displayMetrics.heightPixels * 0.07f
                }

                return true
            }

            passio_FoodNet_Yolo -> {
                val modelName = "${passio_FoodNet_Yolo.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val odFile =
                    fileManager.getStoredFile(
                        context,
                        passio_FoodNet_Yolo,
                        checkAlternatives = false
                    )
                if (odFile == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }
                val inputSize = Size(
                    PassioRecognizer.TF_YOLO_INPUT_SIZE,
                    PassioRecognizer.TF_YOLO_INPUT_SIZE
                )

                objectDetector = TFLiteYoloObjectDetector(inputSize).apply {
                    createFromSecuredExternalModel(odFile)
                }

                return true
            }

            else -> throw IllegalArgumentException("No known file type: ${fileType.name}")
        }
    }

    override fun getExtension(): String = "passiosecure"
}