package ai.passio.passiosdk.passiofood.recommend

import ai.passio.passiosdk.core.authentication.TokenService
import ai.passio.passiosdk.core.network.NetworkCallback
import ai.passio.passiosdk.core.network.NetworkService
import ai.passio.passiosdk.core.network.NetworkStringTask
import ai.passio.passiosdk.core.os.NativeUtils
import ai.passio.passiosdk.core.utils.PassioLog
import ai.passio.passiosdk.passiofood.PassioMealTime
import ai.passio.passiosdk.passiofood.PassioSearchNutritionPreview
import ai.passio.passiosdk.passiofood.PassioFoodDataInfo
import ai.passio.passiosdk.passiofood.search.SearchResult
import org.json.JSONArray

internal object SuggestionService {

    fun fetchSuggestions(
        mealTime: PassioMealTime,
        dev: Boolean,
        languageCode: String?,
        callback: (result: List<SearchResult>) -> Unit
    ) {
        fetchToken(dev) { token ->
            if (token == null) {
                callback(emptyList())
                return@fetchToken
            }

            fetchSuggestionsInternal(mealTime, token, dev, languageCode, callback)
        }
    }

    private fun fetchSuggestionsInternal(
        mealTime: PassioMealTime,
        token: String,
        dev: Boolean,
        languageCode: String?,
        callback: (result: List<SearchResult>) -> Unit
    ) {
        val url = NativeUtils.instance.nativeGetSuggestionURL(dev)
        val headers = mutableListOf("Authorization" to token)
        if (languageCode != null) {
            headers.add("Localization-ISO" to languageCode)
        }
        val task = NetworkStringTask(url + mealTime.mealName, headers)
        NetworkService.instance.doRequestTrackTokens(task, object : NetworkCallback<String> {
            override fun onFailure(code: Int, message: String) {
                PassioLog.w(
                    this@SuggestionService::class.java.simpleName,
                    "Could not fetch suggestions: $message"
                )
                callback(emptyList())
            }

            override fun onTokenExpired() {
                fetchSuggestions(mealTime, dev, languageCode, callback)

            }

            override fun onSuccess(result: String) {
                val jArray = JSONArray(result)
                val list = mutableListOf<SearchResult>()
                for (i in 0 until jArray.length()) {
                    list.add(SearchResult(jArray.getJSONObject(i).toString()))
                }
                callback(list)
            }

        }, "fetchSuggestions")
    }

    private fun fetchToken(
        dev: Boolean = false,
        callback: (token: String?) -> Unit
    ) {

        TokenService.getInstance().getToken(
            dev,
            { token ->
                callback(token)
            }, { _ ->
                callback(null)
            }
        )
    }
}