package ai.passio.passiosdk.core.authentication

import ai.passio.passiosdk.core.network.NetworkCallback
import ai.passio.passiosdk.core.network.NetworkService
import ai.passio.passiosdk.core.network.PostNetworkTask
import ai.passio.passiosdk.core.sharedpreferences.LicenseTokenPreferencesManager
import ai.passio.passiosdk.core.utils.PassioLog
import ai.passio.passiosdk.passiofood.advisor.AdvisorPreferencesManager
import android.content.Context
import org.json.JSONObject

private const val URL_DEV = "https://api-dev.passiolife.com/v2/token-cache/unified/oauth/token/"
private const val URL = "https://api.passiolife.com/v2/token-cache/unified/oauth/token/"

internal class LicenseTokenService(
    context: Context,
    licenseKey: String,
) : TokenService(context, licenseKey) {

    override fun getUrl(dev: Boolean): String {
        return if (dev) {
            URL_DEV + licenseKey
        } else {
            URL + licenseKey
        }
    }

}