package ai.passio.passiosdk.core.authentication

import ai.passio.passiosdk.core.network.NetworkTask
import org.json.JSONObject
import java.io.BufferedWriter
import java.io.IOException
import java.io.OutputStreamWriter
import java.net.URL
import javax.net.ssl.HttpsURLConnection

internal class TokenFetchTask(
    private val urlString: String,
) : NetworkTask<String>() {

    override fun executeTask(): String {
        val url = URL(urlString)
        var connection: HttpsURLConnection? = null
        return try {
            connection = (url.openConnection() as? HttpsURLConnection)
            connection?.run {
                // Timeout for reading InputStream arbitrarily set to 3000ms.
                readTimeout = 3000
                // Timeout for connection.connect() arbitrarily set to 3000ms.
                connectTimeout = 3000
                // For this use case, set HTTP method to GET.
                requestMethod = "POST"
                // Already true by default but setting just in case; needs to be true since this request
                // is carrying an input (response) body.
                doOutput = true
                doInput = true
                // Content type header
                setRequestProperty("Content-Type", "application/json")
                // Open communications link (network traffic occurs here).
                if (enableLog) {
                    logRequest(this)
                }
                connect()
                //publishProgress(CONNECT_SUCCESS)
                if (enableLog) {
                    logResponse(this)
                }
                checkResponse(connection)
                // Retrieve the response body as an InputStream.
                //publishProgress(GET_INPUT_STREAM_SUCCESS, 0)

                getBody(inputStream)
            } ?: throw IOException("Could not open http connection")
        } finally {
            // Close Stream and disconnect HTTPS connection.
            connection?.inputStream?.close()
            connection?.disconnect()
        }
    }

    private fun createJSONRequest(
        clientID: String,
        clientSecret: String,
        audience: String
    ): JSONObject {
        val jsonObject = JSONObject()
        jsonObject.put("client_id", clientID)
        jsonObject.put("client_secret", clientSecret)
        jsonObject.put("audience", audience)
        jsonObject.put("grant_type", "client_credentials")
        return jsonObject
    }
}