package ai.passio.passiosdk.core.camera

import android.util.Size
import androidx.camera.core.CameraSelector
import androidx.camera.core.ImageProxy
import java.lang.ref.WeakReference

internal abstract class PassioCameraProxy {

    interface PassioCameraListener {
        fun onFrameSize(
            frameWidth: Int,
            frameHeight: Int,
            previewWidth: Int,
            previewHeight: Int,
            orientation: Int
        )

        fun analyzeImage(imageProxy: ImageProxy)
    }

    protected var viewProviderRef: WeakReference<PassioCameraViewProvider>? = null
    protected var passioCameraListener: PassioCameraListener? = null

    open fun setCameraViewProvider(passioCameraViewProvider: PassioCameraViewProvider) {
        viewProviderRef = WeakReference(passioCameraViewProvider)
    }

    fun setCameraListener(passioCameraListener: PassioCameraListener) {
        this.passioCameraListener = passioCameraListener
    }

    protected var frameTime: Long = 1000L

    fun setTimeBetweenFrames(time: Long) {
        this.frameTime = time
    }

    abstract fun startCamera(
        displayRotation: Int,
        @CameraSelector.LensFacing cameraFacing: Int,
        onCameraReady: (data: PassioCameraData) -> Unit
    )

    abstract fun startCamera(
        configurator: PassioCameraConfigurator,
        onCameraReady: (data: PassioCameraData) -> Unit
    )

    open fun stopCamera() {
        viewProviderRef?.clear()
        viewProviderRef = null
    }

    abstract fun changeAspectRatio(
        displayRotation: Int,
        aspectRatio: Int,
        @CameraSelector.LensFacing cameraFacing: Int,
        onCameraReady: (data: PassioCameraData) -> Unit
    )

    abstract fun runOnCameraThread(task: Runnable)

    abstract fun getSensorRotation(): Int?

    abstract fun getFrameSize(): Size

    abstract fun getPreviewSize(): Size

    abstract fun enableTapToFocus()

    abstract fun enableFlashlight(enabled: Boolean): Boolean

    abstract fun setZoomLevel(zoom: Float): Boolean

    abstract fun getMinMaxCameraZoomLevel(): Pair<Float?, Float?>?
}