package ai.passio.passiosdk.core.config

import android.content.Context
import android.net.Uri

abstract class BaseConfiguration(val appContext: Context, val key: String) {

    /**
     * This method requires that the correct files were already downloaded and that the [Uri]s for
     * these files are available. Providing a list of Uris for the files needed for the SDK to work
     * the SDK will copy them to it's internal directory (using the App's Cache folder). If the
     * configuration process is completed by returning [PassioMode.IS_READY_FOR_DETECTION], the files
     * provided in the [localFiles] property can be deleted from the original location because the SDK
     * will use the copies in the App's Cache folder.
     */
    var localFiles: List<Uri>? = null

    /**
     * Use [debugMode] = 1 to get more verbose logs.
     */
    var debugMode: Int = 0
}