package ai.passio.passiosdk.core.event

internal class PassioEventBus private constructor() {

    companion object {

        @Volatile
        private var instance: PassioEventBus? = null

        fun getInstance() = instance ?: synchronized(this) {
            instance ?: PassioEventBus().also { instance = it }
        }

    }

    interface PassioEventListener {
        fun onEvent(tag: String, message: String)
    }

    private var listeners = mutableSetOf<PassioEventListener>()

    fun registerListener(passioEventListener: PassioEventListener) {
        synchronized(listeners) {
            listeners.add(passioEventListener)
        }
    }

    fun unRegisterListener(passioEventListener: PassioEventListener) {
        synchronized(listeners) {
            listeners.remove(passioEventListener)
        }
    }

    fun submitEvent(tag: String, message: String) {
        synchronized(listeners) {
            listeners.forEach { listener ->
                listener.onEvent(tag, message)
            }
        }
    }
}