package ai.passio.passiosdk.core.icons

import ai.passio.passiosdk.core.network.NetworkBinaryTask
import ai.passio.passiosdk.core.network.NetworkService
import ai.passio.passiosdk.core.network.SimpleNetworkCallback
import ai.passio.passiosdk.core.os.NativeUtils
import ai.passio.passiosdk.core.utils.PassioLog
import ai.passio.passiosdk.passiofood.metadata.MetadataManager
import android.content.Context
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException
import java.io.InputStream

internal class IconService(
    private val metadataManager: MetadataManager
) {

    private fun getMappedId(iconId: String): String {
        return metadataManager.getMappedIcon(iconId) ?: iconId
    }

    fun getIconURL(passioID: String, size: IconSize): String {
        val mapped = getMappedId(passioID)
        return "${NativeUtils.instance.nativeGetIconUrl()}$mapped-${size.dimen}.jpg"
    }

    fun fetchIcon(
        passioID: String,
        size: IconSize = IconSize.PX90,
        callback: (bitmap: Bitmap?) -> Unit
    ) {
        val urlString = getIconURL(passioID, size)

        val task = NetworkBinaryTask(urlString)
        NetworkService.instance.doRequest(task, object : SimpleNetworkCallback<ByteArray>() {
            override fun onFailure(code: Int, message: String) {
                PassioLog.w(
                    this@IconService::class.java.simpleName,
                    "Failed to fetch icon: $passioID"
                )
                callback(null)
            }

            override fun onSuccess(result: ByteArray) {
                val bitmap = BitmapFactory.decodeByteArray(result, 0, result.size)
                callback(bitmap)
            }
        })
    }
}