package ai.passio.passiosdk.core.utils

import java.io.InputStream
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.channels.Channels

internal class PassioIOBuffer(outputLength: Int) {
    val buffer: ByteBuffer = ByteBuffer.allocateDirect(outputLength).apply {
        order(ByteOrder.nativeOrder())
    }
    lateinit var outputBuffer: ByteBuffer

    fun write(inputStream: InputStream) {
        Channels.newChannel(inputStream).read(buffer)
        buffer.rewind()
        outputBuffer = ByteBuffer.wrap(buffer.array())
    }

}