package ai.passio.passiosdk.passiofood.advisor

import ai.passio.passiosdk.core.sharedpreferences.CorePreferencesManager
import android.content.Context

internal class AdvisorPreferencesManager(context: Context) : CorePreferencesManager(context) {

    companion object Key {
        private const val TOKEN_EXPIRATION = "advisorTokenExpiration"
        private const val TOKEN = "advisorToken"
        private const val TOKEN_CUSTOMER_ID = "advisorCustomerId"
    }

    fun getTokenExpirationTime(): Long {
        return sharedPreferences.getLong(TOKEN_EXPIRATION, 0L)
    }

    fun setTokenExpirationTime(token: String, customerId: String, expiresAt: Long) {
        sharedPreferences.edit().putString(TOKEN, token).apply()
        sharedPreferences.edit().putLong(TOKEN_EXPIRATION, expiresAt).apply()
        sharedPreferences.edit().putString(TOKEN_CUSTOMER_ID, customerId).apply()
    }

    fun getToken(): String? = sharedPreferences.getString(TOKEN, null)

    fun getCustomerId(): String? = sharedPreferences.getString(TOKEN_CUSTOMER_ID, null)

    fun deleteToken() {
        sharedPreferences.edit().putString(TOKEN, null).apply()
        sharedPreferences.edit().putString(TOKEN_CUSTOMER_ID, null).apply()
    }

}