package ai.passio.passiosdk.passiofood.advisor

import ai.passio.passiosdk.core.authentication.TokenService
import ai.passio.passiosdk.core.network.NetworkCallback
import ai.passio.passiosdk.core.network.NetworkService
import ai.passio.passiosdk.core.network.PostNetworkTask
import ai.passio.passiosdk.core.os.NativeUtils
import ai.passio.passiosdk.core.report.PostJsonNetworkTask
import ai.passio.passiosdk.core.utils.PassioLog
import android.content.Context
import org.json.JSONObject

// private const val DEV_KEY = "1xe6qOCRboApvzzbNMEO3UnUgqKK28goXF9QuI1dgcrP"

internal class AdvisorTokenService(context: Context) {

    data class AdvisorToken(
        val token: String,
        val customerId: String
    )

    private val preferences = AdvisorPreferencesManager(context)

    fun invalidateToken() {
        preferences.deleteToken()
    }

    fun fetchToken(licenseKey: String, dev: Boolean, callback: (result: AdvisorToken?) -> Unit) {
        val tokenExpirationTime = preferences.getTokenExpirationTime()

        if (System.currentTimeMillis() < tokenExpirationTime) {
            val token = preferences.getToken()
            val customerId = preferences.getCustomerId()
            if (token != null && customerId != null) {
                callback(AdvisorToken(token, customerId))
                return
            }
        }

        val url = NativeUtils.instance.nativeGetAdvisorTokenUrl(dev)
        val task = PostNetworkTask(url + licenseKey)

        NetworkService.instance.doRequest(task, object : NetworkCallback<String> {
            override fun onFailure(code: Int, message: String) {
                PassioLog.e(
                    AdvisorTokenService::class.java.simpleName,
                    "Could not fetch token: $message"
                )
                callback(null)
            }

            override fun onTokenExpired() {/* NO-OP */
            }

            override fun onSuccess(result: String) {
                val responseJson = JSONObject(result)
                val token = "Bearer ${responseJson.getString("access_token")}"
                val customerId = responseJson.getString("customer_id")
                val expiresIn = responseJson.getInt("expires_in") * 1000L
                PassioLog.i(
                    TokenService::class.java.simpleName,
                    "Advisor token fetch success, expiration time: $expiresIn ms"
                )
                preferences.setTokenExpirationTime(
                    token,
                    customerId,
                    System.currentTimeMillis() + expiresIn
                )
                callback(AdvisorToken(token, customerId))
            }

        })
    }
}