package ai.passio.passiosdk.passiofood.config

import ai.passio.passiosdk.core.utils.asStringList
import ai.passio.passiosdk.core.utils.getJSONArrayOptional
import ai.passio.passiosdk.core.utils.getListOptional
import org.json.JSONObject

internal class PassioMetadata(json: String) : JSONObject(json) {
    val confusionAlternatives: Map<String, List<String>> by lazy {
        val returnMap = mutableMapOf<String, List<String>>()
        val rootObject = this.getJSONObject("confusionAlternatives")
        rootObject.keys().forEach { key ->
            returnMap[key] = rootObject.getJSONArray(key).asStringList()
        }
        returnMap
    }
    val invisibleIngredients: Map<String, List<String>> by lazy {
        val returnMap = mutableMapOf<String, List<String>>()
        val rootObject = this.getJSONObject("invisibleIngredients")
        rootObject.keys().forEach { key ->
            returnMap[key] = rootObject.getJSONArray(key).asStringList()
        }
        returnMap
    }
    val hash: String by lazy { getString("hash") }
    val labelNames: List<PassioMetadataLabel> by lazy {
        val returnList = mutableListOf<PassioMetadataLabel>()
        val rootObject = this.getJSONArray("labelNames")
        for (i in 0 until rootObject.length()) {
            val jsonObject = rootObject.getJSONObject(i)
            returnList.add(PassioMetadataLabel(jsonObject.toString()))
        }
        returnList
    }
}

internal class PassioMetadataLabel(json: String) : JSONObject(json) {
    val labelName: String by lazy { getString("labelname") }
    val displayName: String by lazy { getString("displayName") }
    val children: List<PassioMetadataLabel>? by lazy {
        getListOptional(this, "children", ::PassioMetadataLabel)
    }
}