package ai.passio.passiosdk.passiofood.data.model

/**
 * Default icons packed within the SDK's asset folder.
 */
@Suppress("EnumEntryName")
enum class IconDefaults(val iconName: String) {
    passioRecipeIcon("passioSDKRecipeIcon"),
    passioFoodItemIcon("passioSDKFoodItemIcon"),
    passioBarcodeIcon("passioSDKBarcodeIcon"),
    passioBrandedIcon("passioSDKBrandedIcon"),
    passioNutritionIcon("passioSDKNutritionIcon");

    companion object {
        /**
         * For a given [PassioIDEntityType] returns the corresponding
         * default icon.
         */
        fun entityTypeToIcon(entityType: PassioIDEntityType): IconDefaults {
            return when (entityType) {
                PassioIDEntityType.barcode -> passioBarcodeIcon
                PassioIDEntityType.recipe -> passioRecipeIcon
                PassioIDEntityType.packagedFoodCode -> passioBrandedIcon
                PassioIDEntityType.nutritionFacts -> passioNutritionIcon
                PassioIDEntityType.group,
                PassioIDEntityType.item,
                PassioIDEntityType.favorite -> passioFoodItemIcon
            }
        }
    }
}