package ai.passio.passiosdk.passiofood.data.model

import ai.passio.passiosdk.passiofood.PassioID
import ai.passio.passiosdk.passiofood.data.model.internal.PassioAlternativeResult

/**
 * Food items in the nutritional database are structured in a
 * hierarchical way. The [PassioAlternative] data class
 * represents a child, sibling or a parent of a given food item.
 */
internal data class PassioAlternative(
    val passioID: PassioID = "",
    val name: String = "",
    val number: Double? = null,
    val unit: String? = null
) {
    internal constructor(result: PassioAlternativeResult, name: String) : this(
        result.passioID,
        name,
        result.number,
        result.unit
    )
}