package ai.passio.passiosdk.passiofood.data.model

/**
 * Defines different categories of food items provided by the SDK.
 */
@Suppress("EnumEntryName")
enum class PassioIDEntityType(val value: String) {
    group("group"),
    item("item"),
    recipe("recipe"),
    barcode("barcode"),
    packagedFoodCode("packagedFoodCode"),
    favorite("favorite"),
    nutritionFacts("nutritionFacts");

    companion object {
         fun fromString(entityTypeString: String): PassioIDEntityType {
            return when (entityTypeString) {
                "group" -> group
                "item" -> item
                "recipe" -> recipe
                "barcode" -> barcode
                "packagedFoodCode" -> packagedFoodCode
                "favorite" -> favorite
                "nutritionFacts" -> nutritionFacts
                else -> throw RuntimeException("No known entity type: $entityTypeString")
            }
        }
    }


}