package ai.passio.passiosdk.passiofood.data.model

import ai.passio.passiosdk.passiofood.data.measurement.Grams
import ai.passio.passiosdk.passiofood.data.measurement.UnitMass
import ai.passio.passiosdk.passiofood.upc.ResponseIngredient

data class PassioIngredient(
    val id: String,
    val refCode: String,
    val name: String,
    val iconId: String,
    val amount: PassioFoodAmount,
    val referenceNutrients: PassioNutrients,
    val metadata: PassioFoodMetadata,
) {

    internal companion object {
        fun fromResponse(result: ResponseIngredient, topLevelIcon: String): PassioIngredient {
            val refCode = result.refCode ?: ""
            val nutrients = PassioNutrients(UnitMass(Grams, 100.0), result.nutrients ?: listOf())
            val amount = PassioFoodAmount.fromResponse(result.portions)
            val metadata = PassioFoodMetadata.fromSearchResult(result)
            val iconId = result.iconId ?: topLevelIcon

            return PassioIngredient(
                result.id ?: "",
                refCode,
                result.name ?: "",
                iconId,
                amount,
                nutrients,
                metadata
            )
        }
    }

    fun nutrients(weight: UnitMass): PassioNutrients {
        if (weight.gramsValue() == referenceNutrients.referenceWeight.gramsValue()) {
            return referenceNutrients
        }

        return PassioNutrients(referenceNutrients, weight)
    }

    fun weight(): UnitMass {
        return amount.weight()
    }
}