package ai.passio.passiosdk.passiofood.mlkit

internal object BarcodeDetectorFactory {

    fun create(): PassioBarcodeScanner {
        return try17()
    }

    private fun try17(): PassioBarcodeScanner {
        val builderClass =
            Class.forName("com.google.mlkit.vision.barcode.BarcodeScannerOptions\$Builder")
        val ctor = builderClass.getDeclaredConstructor()

        val builderInstance = ctor.newInstance()

        val barcodeFormats = getBarcodeFormats()

        val setFormatsMethod = builderClass.getDeclaredMethod(
            "setBarcodeFormats",
            barcodeFormats[0]::class.java,
            barcodeFormats::class.java
        )

        setFormatsMethod.invoke(
            builderInstance,
            barcodeFormats[0],
            barcodeFormats.copyOfRange(1, barcodeFormats.size)
        )

        val buildMethod = builderClass.getMethod("build")
        val barcodeScannerOptions = buildMethod.invoke(builderInstance)

        val scanningClass = Class.forName("com.google.mlkit.vision.barcode.BarcodeScanning")
        val getClientMethod =
            scanningClass.getMethod("getClient", barcodeScannerOptions::class.java)

        val barcodeScanner = getClientMethod.invoke(null, barcodeScannerOptions)

        return BarcodeScannerProxy17(barcodeScanner)
    }

    private fun getBarcodeFormats(): IntArray {
        val clazz = ReflectionCache.barcodeClass()
        val format_EAN_13 = clazz.getDeclaredField("FORMAT_EAN_13").get(null)
        val format_EAN_8 = clazz.getDeclaredField("FORMAT_EAN_8").get(null)
        val format_UPC_E = clazz.getDeclaredField("FORMAT_UPC_E").get(null)
        val format_UPC_A = clazz.getDeclaredField("FORMAT_UPC_A").get(null)

        return intArrayOf(
            format_EAN_13 as Int,
            format_EAN_8 as Int,
            format_UPC_E as Int,
            format_UPC_A as Int
        )
    }
}