package ai.passio.passiosdk.passiofood.recognition.filter

internal abstract class Filter(
    protected val nClasses: Int,
) {
    data class FilterCandidate(
        val index: Int,
        val confidence: Float,
    )

    protected var stateEstimate = floatArrayOf()
    protected var divergence: Float = 1f

    fun top(k: Int = 3, threshold: Float = 0f): Pair<Float, List<FilterCandidate>> {
        val indexList = mutableListOf<Pair<Int, Float>>()
        stateEstimate.forEachIndexed { index, fl ->
            if (fl >= threshold) {
                indexList.add(index to fl)
            }
        }
        if (indexList.isEmpty()) return 1f to emptyList()

        indexList.sortByDescending { it.second }
        val topK = indexList.subList(0, minOf(k, indexList.size))

        return divergence to topK.map { FilterCandidate(it.first, it.second) }
    }

    abstract fun step(observation: FloatArray): FloatArray

    abstract fun resetFilter()
}