package ai.passio.passiosdk.passiofood.recommend

import ai.passio.passiosdk.core.utils.getList
import ai.passio.passiosdk.core.utils.getListOptional
import ai.passio.passiosdk.passiofood.search.SearchResult
import org.json.JSONObject

internal class MealPlanResponse(json: String): JSONObject(json) {
    val dayNumber: Int by lazy { getInt("dayNumber") }
    val dayTitle: String by lazy { getString("dayTitle") }
    val dayMeals: List<MealPlanDayResponse> by lazy {
        getList(this, "meal", ::MealPlanDayResponse)
    }
}

internal class MealPlanDayResponse(json: String): JSONObject(json) {
    val mealTimeLabel: String by lazy { getString("mealTimeLabel") }
    val mealTimeTitle: String by lazy { getString("mealTimeTitle") }
    val meals: List<SearchResult> by lazy {
        val list = mutableListOf<SearchResult>()
        val jArray = getJSONArray("meal")
        for (i in 0 until jArray.length()) {
            list.add(SearchResult(jArray.getJSONObject(i).toString()))
        }
        list
    }
}