package ai.passio.passiosdk.passiofood.utils

internal object MarkdownHelper {

    private val headerRegex = Regex("""#+\s*""") // Matches one or more '#' characters followed by optional whitespace
    private val listRegex = Regex("""(?:^|\n)(?:\s*-\s*)+""") // Matches lists starting with '-' characters
    private val italicRegex = Regex("""\*{1,2}""") // Matches '*' or '**' for italic text
    private val boldRegex = Regex("""\*{2}""") // Matches '**' for bold text

    fun removeMarkdownTags(markdownString: String): String {
        var cleanedString = markdownString
        cleanedString = cleanedString.replace(headerRegex, "")
        cleanedString = cleanedString.replace(listRegex, "\n")
        cleanedString = cleanedString.replace(italicRegex, "")
        cleanedString = cleanedString.replace(boldRegex, "")

        return cleanedString.trim() // Trim any leading or trailing whitespace
    }
}