package ai.passio.passiosdk.passiofood.view

import ai.passio.passiosdk.core.camera.PassioCameraViewProvider
import ai.passio.passiosdk.passiofood.PassioSDK
import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import androidx.camera.view.PreviewView
import androidx.lifecycle.LifecycleOwner

class PassioCameraView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr), PassioCameraViewProvider {

    private val previewView = PreviewView(context, attrs, defStyleAttr)
    private var lifecycleOwner: LifecycleOwner? = null
    private var cameraStarted = false

    init {
        this.addView(previewView)
        previewView.layoutParams.apply {
            width = LayoutParams.MATCH_PARENT
            height = LayoutParams.MATCH_PARENT
        }
    }

    fun setLifecycleOwner(lifecycleOwner: LifecycleOwner) {
        this.lifecycleOwner = lifecycleOwner
        if (!cameraStarted) {
            PassioSDK.instance.startCamera(this)
            cameraStarted = true
        }

    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        if (lifecycleOwner != null && !cameraStarted) {
            PassioSDK.instance.startCamera(this)
        }
    }

    override fun requestPreviewView(): PreviewView = previewView

    override fun requestCameraLifecycleOwner(): LifecycleOwner = lifecycleOwner!!

}