package ai.passio.passiosdk.passiofood.voice.local

internal data class Feature(
    val inputIds: IntArray,
    val inputMask: IntArray,
    val segmentIds: IntArray,
    val origTokens: List<String>,
    val tokenToOrigMap: Map<Int, Int>
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Feature

        if (!inputIds.contentEquals(other.inputIds)) return false
        if (!inputMask.contentEquals(other.inputMask)) return false
        if (!segmentIds.contentEquals(other.segmentIds)) return false
        if (origTokens != other.origTokens) return false
        if (tokenToOrigMap != other.tokenToOrigMap) return false

        return true
    }

    override fun hashCode(): Int {
        var result = inputIds.contentHashCode()
        result = 31 * result + inputMask.contentHashCode()
        result = 31 * result + segmentIds.contentHashCode()
        result = 31 * result + origTokens.hashCode()
        result = 31 * result + tokenToOrigMap.hashCode()
        return result
    }
}