package ai.passio.passiosdk.passiofood.voting

import ai.passio.passiosdk.passiofood.ObjectDetectionCandidate

internal class SmallerBoundingBoxStrategy : ObjectDetectionStrategy() {

    override fun discardCandidate(
        firstCandidate: ObjectDetectionCandidate,
        secondCandidate: ObjectDetectionCandidate
    ): ObjectDetectionCandidate {
        val firstArea = firstCandidate.boundingBox.width() * firstCandidate.boundingBox.height()
        val secondArea = secondCandidate.boundingBox.width() * secondCandidate.boundingBox.height()
        return if (firstArea >= secondArea) {
            firstCandidate
        } else {
            secondCandidate
        }
    }
}