package ai.passio.passiosdk.passiofood.search

import ai.passio.passiosdk.core.utils.getStringOptional
import ai.passio.passiosdk.passiofood.data.network.TokenResponse
import ai.passio.passiosdk.passiofood.upc.ResponseIngredient
import ai.passio.passiosdk.passiofood.upc.ResponsePortions
import org.json.JSONObject

internal class ResponseFood(json: String): TokenResponse(json) {
    val alternatives: List<ResponseAlternative> by lazy {
        val list = mutableListOf<ResponseAlternative>()
        val jArray = getJSONArray("alternatives")
        for (i in 0 until jArray.length()) {
            list.add(ResponseAlternative(jArray.getJSONObject(i).toString()))
        }
        list
    }
    val results: List<ResponseFoodItem> by lazy {
        val list = mutableListOf<ResponseFoodItem>()
        val jArray = getJSONArray("results")
        for (i in 0 until jArray.length()) {
            list.add(ResponseFoodItem(jArray.getJSONObject(i).toString()))
        }
        list
    }
}

internal class ResponseFoodItem(json: String): JSONObject(json) {
    val displayName: String by lazy { getString("displayName") }
    val internalName: String by lazy { getString("internalName") }
    val iconId: String by lazy { getString("iconId") }
    val type: String by lazy { getString("type") }
    val internalId: String by lazy { getString("internalId") }
    val portions: List<ResponsePortions> by lazy {
        val list = mutableListOf<ResponsePortions>()
        val jArray = getJSONArray("portions")
        for (i in 0 until jArray.length()) {
            list.add(ResponsePortions(jArray.getJSONObject(i).toString()))
        }
        list
    }
    val ingredients: List<ResponseIngredient> by lazy {
        val list = mutableListOf<ResponseIngredient>()
        val jArray = getJSONArray("ingredients")
        for (i in 0 until jArray.length()) {
            list.add(ResponseIngredient(jArray.getJSONObject(i).toString()))
        }
        list
    }
    val refCode: String? by lazy { this.getStringOptional("refCode") }
}

internal class ResponseAlternative(json: String): JSONObject(json) {
    val displayName: String by lazy { getString("displayName") }
    val iconId: String by lazy { getString("iconId") }
    val labelId: String by lazy { getString("labelId") }
}