package ai.passio.passiosdk.core.search.fuzzywuzzy;

class ExtractedResult implements Comparable<ExtractedResult> {

    private String string;
    private int score;
    private int index;

    public ExtractedResult(String string, int score, int index) {
        this.string = string;
        this.score = score;
        this.index = index;
    }

    @Override
    public int compareTo(ExtractedResult o) {
        return Integer.compare(this.getScore(), o.getScore());
    }

    public String getString() {
        return string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public int getScore() {
        return score;
    }

    public void setMaxScore() {
        score = 100;
    }

    public int getIndex() {
        return index;
    }

    @Override
    public String toString() {
        return "(string: " + string + ", score: " + score + ", index: " + index+ ")";
    }
}