package ai.passio.passiosdk.core.camera

import android.view.Surface
import androidx.camera.core.AspectRatio
import androidx.camera.core.CameraSelector.LensFacing
import androidx.camera.core.ImageAnalysis
import androidx.camera.core.Preview
import androidx.camera.core.impl.ImageOutputConfig.RotationValue

interface PassioCameraConfigurator {

    @RotationValue
    fun displayRotation(): Int = Surface.ROTATION_0

    @LensFacing
    fun cameraFacing(): Int

    fun preview(): Preview

    fun analyzer(): ImageAnalysis {
        return ImageAnalysis.Builder().apply {
            setTargetAspectRatio(AspectRatio.RATIO_16_9)
        }.build()
    }

    fun setZoomRatio(minRatio: Float, maxRatio: Float): Float = 1f

    fun tapToFocus(): Boolean = true
}
