package ai.passio.passiosdk.core.config

import org.json.JSONArray

internal class ModelConfiguration(json: String) : JSONArray(json) {

    companion object {
        val EMPTY_CONFIG: ModelConfiguration
            get() {
                val emptyJsonArray = JSONArray()
                return ModelConfiguration(emptyJsonArray.toString())
            }
    }

    fun getModelByType(typePassio: SDKFileType): String? {
        for (i in 0 until this.length()) {
            val sdkFile = this.getString(i)
            if (sdkFile.split(".")[0] == typePassio.name) {
                return sdkFile
            }
        }

        return null
    }

    @Deprecated("", ReplaceWith("null"))
    fun getModelByName(name: String): String? {
        return null
    }

    fun updateFile(fileName: String) {
        for (i in 0 until this.length()) {
            val sdkFile = this.getString(i)
            if (sdkFile.split(".")[0] == fileName.split(".")[0]) {
                this.put(i, fileName)
                return
            }
        }

        this.put(fileName)
    }

}

internal interface SDKFileType {
    val name: String
    fun alternative(): SDKFileType? = null
}

