package ai.passio.passiosdk.passiofood.utils

import ai.passio.passiosdk.passiofood.BarcodeCandidate
import ai.passio.passiosdk.passiofood.DebugCandidate
import ai.passio.passiosdk.passiofood.DetectedCandidate
import ai.passio.passiosdk.passiofood.FoodCandidates
import ai.passio.passiosdk.passiofood.FoodRecognitionListener
import ai.passio.passiosdk.passiofood.PackagedFoodCandidate
import ai.passio.passiosdk.passiofood.nutritionfacts.PassioNutritionFacts
import android.graphics.Bitmap
import android.util.Log
import java.util.concurrent.Executor
import java.util.concurrent.atomic.AtomicInteger
import java.util.concurrent.atomic.AtomicReference

internal class AggregateHelper(
    private val bitmap: Bitmap?,
    awaitingResults: Int,
    private val mainExecutor: Executor,
    private val currentListenerRef: AtomicReference<FoodRecognitionListener>,
) {
    var awaitingResults = AtomicInteger(awaitingResults)
    var foodCandidates: List<DetectedCandidate>? = null
    var barcodeCandidates: List<BarcodeCandidate>? = null
    var packagedFoodCandidate: List<PackagedFoodCandidate>? = null

    fun onFoodCandidates(
        candidates: List<DebugCandidate>?,
        foodRecognitionListener: FoodRecognitionListener
    ) {
        synchronized(this) {
            if (awaitingResults.get() <= 0) {
                throw IllegalAccessException("Result already delivered")
            }

            foodCandidates = candidates
            tryDeliverResult(foodRecognitionListener)
        }
    }

    fun onBarcodeCandidates(
        candidates: List<BarcodeCandidate>,
        foodRecognitionListener: FoodRecognitionListener
    ) {
        synchronized(this) {
            if (awaitingResults.get() <= 0) {
                throw IllegalAccessException("Result already delivered")
            }

            barcodeCandidates = candidates
            tryDeliverResult(foodRecognitionListener)
        }
    }

    fun onPackagedFoodCandidate(
        candidates: List<PackagedFoodCandidate>?,
        foodRecognitionListener: FoodRecognitionListener
    ) {
        synchronized(this) {
            if (awaitingResults.get() <= 0) {
                throw IllegalAccessException("Result already delivered")
            }

            this.packagedFoodCandidate = candidates
            tryDeliverResult(foodRecognitionListener)
        }
    }

    private fun tryDeliverResult(foodRecognitionListener: FoodRecognitionListener) {
        if (awaitingResults.decrementAndGet() == 0) {
            mainExecutor.execute {
                // The listener has changed.
                // The result that was delivered belong to the older listener
                if (foodRecognitionListener === currentListenerRef.get()) {
                    foodRecognitionListener.onRecognitionResults(
                        FoodCandidates(
                            foodCandidates,
                            barcodeCandidates,
                            packagedFoodCandidate
                        ),
                        bitmap,
                    )
                } else {
                    Log.i(this::class.java.simpleName, "Recognition listener reference changed")
                }
            }
        }
    }

}