package ai.passio.passiosdk.core.config

import ai.passio.passiosdk.R
import androidx.annotation.StringRes

enum class PassioSDKError(@StringRes val errorRes: Int) {
    MIN_SDK_VERSION(R.string.min_sdk_version),
    KEY_NOT_VALID(R.string.key_not_valid),
    MODELS_NOT_VALID(R.string.models_not_valid),
    LICENSE_KEY_HAS_EXPIRED(R.string.license_expired),
    LICENSE_DECODING_ERROR(R.string.license_decoding_error),
    MODELS_DOWNLOAD_FAILED(R.string.auto_update_failed),
    NETWORK_ERROR(R.string.network_error),
    NO_MODELS_FILES_FOUND(R.string.no_models_files_found),
    METADATA_ERROR(R.string.metadata_error),
    NOT_LICENSED_FOR_THIS_PROJECT(R.string.not_licensed_for_this_project),
    MISSING_DEPENDENCY(R.string.missing_dependency)
}