package ai.passio.passiosdk.core.sharedpreferences

import ai.passio.passiosdk.BuildConfig
import android.content.Context
import android.content.SharedPreferences

internal open class CorePreferencesManager(context: Context) {

    companion object Key {
        private const val PREF_NAME_PREFIX = "PassioPref"
        private const val PREF_LICENSE = "license"
        private const val PREF_PBRODUCT_CACHE = "bProductCache"
        private const val PREF_MODEL_DOWNLOADING = "passioModelDownloading"
        private const val PREF_MODEL_DOWNLOAD_FAILED = "passioModelDownloadFailed"
        private const val PREF_AUTO_UPDATE_RAN = "autoUpdateRan"
        private const val PREF_DATABASE_VERSION = "databaseVersion"
    }

    protected val sharedPreferences: SharedPreferences =
        context.getSharedPreferences(PREF_NAME_PREFIX + BuildConfig.SDK_TYPE , 0)

    fun setLicense(key: String, license: String) {
        val licenseString = key + "||" + System.currentTimeMillis().toString() + "||" + license
        sharedPreferences.edit().putString(PREF_LICENSE, licenseString).apply()
    }

    fun getLicense(key: String): Pair<String, Long>? {
        val licenseString = sharedPreferences.getString(PREF_LICENSE, null) ?: return null
        val split = licenseString.split("||")
        if (split[0] != key) {
            return null
        }
        return Pair(split[2], split[1].toLong())
    }

    fun removeLicense() {
        sharedPreferences.edit().remove(PREF_LICENSE).apply()
    }

    fun setAutoUpdateRan() {
        sharedPreferences.edit().putLong(PREF_AUTO_UPDATE_RAN, System.currentTimeMillis()).apply()
    }

    fun getLastAutoUpdateTime(): Long {
        return sharedPreferences.getLong(PREF_AUTO_UPDATE_RAN, 0L)
    }

    fun setModelDownloading(modelName: String) {
        val set = sharedPreferences.getStringSet(PREF_MODEL_DOWNLOADING, hashSetOf())!!
        val newSet = set.toMutableSet()
        newSet.add(modelName)
        sharedPreferences.edit().putStringSet(PREF_MODEL_DOWNLOADING, newSet).apply()
    }

    fun setModelDownloaded(modelName: String) {
        val set = sharedPreferences.getStringSet(PREF_MODEL_DOWNLOADING, hashSetOf())!!
        val newSet = set.toMutableSet()
        newSet.remove(modelName)
        sharedPreferences.edit().putStringSet(PREF_MODEL_DOWNLOADING, newSet).apply()

        val failed = sharedPreferences.getStringSet(PREF_MODEL_DOWNLOAD_FAILED, hashSetOf())!!
        val newFailedSet = failed.toMutableSet()
        newFailedSet.remove(modelName)
        sharedPreferences.edit().putStringSet(PREF_MODEL_DOWNLOAD_FAILED, newFailedSet).apply()
    }

    fun setModelDownloadFailed(modelName: String) {
        val set = sharedPreferences.getStringSet(PREF_MODEL_DOWNLOADING, hashSetOf())!!
        val newSet = set.toMutableSet()
        newSet.remove(modelName)
        sharedPreferences.edit().putStringSet(PREF_MODEL_DOWNLOADING, newSet).apply()

        val failed = sharedPreferences.getStringSet(PREF_MODEL_DOWNLOAD_FAILED, hashSetOf())!!
        val newFailedSet = failed.toMutableSet()
        newFailedSet.add(modelName)
        sharedPreferences.edit().putStringSet(PREF_MODEL_DOWNLOAD_FAILED, newFailedSet).apply()
    }

    fun getModelsDownloading(): Set<String> {
        return sharedPreferences.getStringSet(PREF_MODEL_DOWNLOADING, mutableSetOf())!!
    }

    fun getModelsDownloadFailed(): Set<String> {
        return sharedPreferences.getStringSet(PREF_MODEL_DOWNLOAD_FAILED, mutableSetOf())!!
    }

    fun getDatabaseVersion(): Int = sharedPreferences.getInt(PREF_DATABASE_VERSION, 0)

    fun setDatabaseVersion(version: Int) {
        sharedPreferences.edit().putInt(PREF_DATABASE_VERSION, version).apply()
    }
}