package ai.passio.passiosdk.core.sharedpreferences

import android.content.Context
import android.util.Base64
import kotlin.experimental.xor

internal class TokenPreferencesManager(context: Context) : CorePreferencesManager(context) {

    companion object Key {
        private const val TOKEN_EXPIRATION = "tokenExpiration"
        private const val TOKEN = "token"
        private const val LICENSE_KEY = "tokenReference"
        private const val DELIMITER = 0xAA.toByte()
    }

    fun getTokenExpirationTime(): Long = sharedPreferences.getLong(TOKEN_EXPIRATION, 0L)

    fun setTokenExpirationTime(token: String, expiresAt: Long) {
        sharedPreferences.edit().putString(TOKEN, token).apply()
        sharedPreferences.edit().putLong(TOKEN_EXPIRATION, expiresAt).apply()
    }

    fun setLicense(licenseKey: String) {
        val inputBytes = licenseKey.toByteArray()
        val delimiterBytes = inputBytes.map { it.xor(DELIMITER) }.toByteArray()
        val delimiterString = Base64.encodeToString(delimiterBytes, Base64.DEFAULT)
        sharedPreferences.edit().putString(LICENSE_KEY, delimiterString).apply()
    }

    fun getLicense(): String? {
        val delimiterString = sharedPreferences.getString(LICENSE_KEY, null) ?: return null
        val delimiterBytes = Base64.decode(delimiterString, Base64.DEFAULT)
        val originalBytes = delimiterBytes.map { it.xor(DELIMITER) }.toByteArray()
        return String(originalBytes)
    }

    fun getToken(): String? = sharedPreferences.getString(TOKEN, null)

    fun deleteToken() {
        sharedPreferences.edit().putString(TOKEN, null).apply()
        sharedPreferences.edit().putLong(TOKEN_EXPIRATION, 0L).apply()
        sharedPreferences.edit().putString(LICENSE_KEY, null).apply()
    }
}