package ai.passio.passiosdk.passiofood.data

import android.util.Base64
import org.json.JSONObject
import java.nio.charset.Charset

internal object DataUtils {

    private const val SHORT_NAME = "shortName"

    fun encodeMetadata(shortName: Boolean): String {
        val metadata = """{"$SHORT_NAME": $shortName}"""
        return Base64.encodeToString(metadata.toByteArray(), Base64.NO_WRAP)
    }

    fun metadataHasShortName(encoded: String): Boolean {
        val decoded = Base64.decode(encoded, Base64.DEFAULT).toString(Charset.defaultCharset())
        val jsonObject = JSONObject(decoded).optJSONObject("metadata")
        return jsonObject?.optBoolean(SHORT_NAME) ?: false
    }
}